/* $Id: linuxipc.c,v 1.45 1997/09/25 15:28:48 jw5 Exp $ */

#include <l4/types.h>
#include <l4/ipc.h>
#include <linux/sched.h> /* task_struct  */
#include <asm/segment.h>

#include "../include/exclpage.h"
#include "../include/debug.h"
#include "../include/handlers.h" /* signal delivery */

int do_signal(unsigned long old_mask, struct pt_regs *regs);
void
check_for_exception_within_emulation_library(void)
{
  extern int emulib_start, emulib_end;
  if ((current->tss.ex_page->regs.eip >= (unsigned long)&emulib_start) &&
      (current->tss.ex_page->regs.eip <= (unsigned long)&emulib_end))
    {
      printk("exception within emulation library: eip: %lx\n",
	     current->tss.ex_page->regs.eip);
      herc_printf("exception %d within emulation library: "
		  "eip: %lx, task: %x\n",
		  current->tss.ex_page->exception_number,
		  current->tss.ex_page->regs.eip,
		  current->tss.user_thread_id.id.task);
    }
}

int 
deliver_signal(void)
{
  /* use exception entry points within kernel 
     e.g. do_divide_error( struct ptregs * regs, long error);
     */
  
  current->tss.ex_page->regs.orig_eax = -1;

  check_for_exception_within_emulation_library();

  switch(current->tss.ex_page->exception_number)
    {
    case 0:  
#ifdef KEVENT
      enter_kdebug("do_divide_error");
#endif
      do_divide_error(&current->tss.ex_page->regs,
		      current->tss.ex_page->error_code);    
      break;
    case 1:
#ifdef KEVENT
      enter_kdebug("do_debug");
#endif
      do_debug(&current->tss.ex_page->regs,
	       current->tss.ex_page->error_code);    
      break;
    case 2:
#ifdef KEVENT
      enter_kdebug("do_nmi");
#endif
      do_nmi(&current->tss.ex_page->regs,
	     current->tss.ex_page->error_code);    
      break;
    case 3:
#ifdef KEVENT
      enter_kdebug("do_int3");
#endif
      do_int3(&current->tss.ex_page->regs,
	      current->tss.ex_page->error_code);    
      break;
    case 4:
#ifdef KEVENT
      enter_kdebug("do_overflow");
#endif
      do_overflow(&current->tss.ex_page->regs,
		  current->tss.ex_page->error_code);    
      break;  
    case 5:
#ifdef KEVENT
      enter_kdebug("do_bounds");
#endif
      do_bounds(&current->tss.ex_page->regs,
		current->tss.ex_page->error_code);    
      break;  
    case 6:
#ifdef KEVENT
      enter_kdebug("do_invalid_op");
#endif
      do_invalid_op(&current->tss.ex_page->regs,
		    current->tss.ex_page->error_code);    
      break;  
    case 7:			/* no */
#ifdef KEVENT
      enter_kdebug("do_device_not_available");
#endif
      do_device_not_available(&current->tss.ex_page->regs,
			      current->tss.ex_page->error_code);    
      break; 
    case 8:			/* no */
#ifdef KEVENT
      enter_kdebug("do_double_fault");
#endif
      do_double_fault(&current->tss.ex_page->regs,
		      current->tss.ex_page->error_code);    
      break;
    case 9:			/* no */
#ifdef KEVENT
      enter_kdebug("do_coprocessor_segment_overrun");
#endif
      do_coprocessor_segment_overrun(&current->tss.ex_page->regs,
				     current->tss.ex_page->error_code);    
      break;  
    case 10:			/* no */
#ifdef KEVENT
      enter_kdebug("do_invalid_TSS");
#endif
      do_invalid_TSS(&current->tss.ex_page->regs,
		     current->tss.ex_page->error_code);    
      break;
    case 11:
#ifdef KEVENT
      enter_kdebug("do_segment_not_present");
#endif
      do_segment_not_present(&current->tss.ex_page->regs,
			     current->tss.ex_page->error_code);    
      break;
    case 12:
#ifdef KEVENT
      enter_kdebug("do_stack_segment");
#endif
      do_stack_segment(&current->tss.ex_page->regs,
		       current->tss.ex_page->error_code);    
      break;
    case 13:
#ifdef KEVENT
      enter_kdebug("do_general_protection");
#endif
      do_general_protection(&current->tss.ex_page->regs,
			    current->tss.ex_page->error_code);    
      break;
    case 14:			/* if pager error */
#ifdef KEVENT
      enter_kdebug("do_page_fault");
#endif
      do_page_fault(&current->tss.ex_page->regs,
		    current->tss.ex_page->error_code);    
      break; 
    case 15:
#ifdef KEVENT
      enter_kdebug("do_coprocessor_error");
#endif
      do_coprocessor_error(&current->tss.ex_page->regs,
			   current->tss.ex_page->error_code);    
      break;  
    case 16:
#ifdef KEVENT
      enter_kdebug("do_reserved");
#endif
      do_reserved(&current->tss.ex_page->regs,
		  current->tss.ex_page->error_code);    
      break;
    case 17:
#ifdef KEVENT
      enter_kdebug("do_alignment_check");
#endif
      do_alignment_check(&current->tss.ex_page->regs,
			 current->tss.ex_page->error_code);    
      break; 
    case 19:
      break; 
    default:
      enter_kdebug("deliver_signal:unknown exception");
      break;
    }

  if (current != FIRST_TASK)
    { /* task[0] can't have signals */
      if ((current->signal & ~(current->blocked)))
	{ /* if there are signals */
	  do_signal(current->blocked, &current->tss.ex_page->regs);
	}
    }

  return 0;
}
