#define SYSCALL_TIMEOUT 0x10
#define CF_MASK		0x00000001	 
#define ENOSYS		38  
#define signal		12    
#define blocked		16
#define flags		20    
    
/*
    Precond:	
		ebx:	system call number
		ebp:	tss of current task
    
    Postcond:	
		eax:	return value of dispatched function
		ecx:	value to be used as msg dope for reply
		edx:	dw0 to be used for reply    	
    		ebx:	dw1 to be used for reply
    Scratched:	
		edi, esi

    dispatch syscall implements the following algorithm:

    get	address of ptregs
    result := -ENOSYS (no such system call)
    IF	system call number is valid
	get address of system call
	IF address of system call is valid
	    clear carry flag in ptregs
	    IF	not system call trace activ
		reserve space on stack for ptregs structure
		transfer first 5 dwords from ptregs structure 
		    to stack (system call parameters)
		invoke system call
		remove parameters from stack (simply adjust stack pointer)
		result:= eax
	    ELSE
		trace system call
		reserve space on stack for ptregs structure
		transfer first 5 dwords from ptregs structure 
		    to stack (system call parameters)
		invoke system call
		remove parameters from stack (simply adjust stack pointer)
		result:= eax
		trace system call
	    ENDIF
	ENDIF
    ENDIF				 
    IF	current task <> task 0  (task 0 can't have signals)
	IF signal pending (signals & ~blocked signals)
	    do_signal
	ENDIF
    ENDIF
    
*/               
.MACRO DISPATCH_SYSCALL
sys_call .REG	(%ebx)

ptregs	.REG	(%edi)
current	.REG	(%ebp)
tmp1	.REG	(%ecx)
tmp2	.REG	(%edx)

/* #define COUNT_SYSTEM_CALLS     */
    /* get ptregs */
#ifdef COUNT_SYSTEM_CALLS    
    incl    SYMBOL_NAME(syscall_count)
#endif    
    movl    OFFS_EXCLUSIV_PAGE(current), ptregs
    /* check whether sys call is valid */
    IFL	    %ebx, $(NR_syscalls)
	    movl	OFFS_PTREGS(ptregs), tmp1
	    testb   $0x20, flags(current)      # PF_TRACESYS
	    IFZ
		/* push parameters */
		leal	-PTREGS_SIZE(%esp), %esp
    		movl	(OFFS_PTREGS+4)(ptregs), tmp2
		movl	tmp1, (%esp)
    		movl	tmp2, 4(%esp)
		movl	(OFFS_PTREGS+8)(ptregs), tmp1
    		movl	(OFFS_PTREGS+12)(ptregs), tmp2
		movl	tmp1, 8(%esp)
		movl	(OFFS_PTREGS+16)(ptregs), tmp1
    		movl	tmp2, 12(%esp)
		movl	tmp1, 16(%esp)
		
		call SYMBOL_NAME(sys_call_table)(,%ebx,4)

    		leal	PTREGS_SIZE(%esp), %esp

		movl	%eax,	(OFFS_PTREGS+OFFS_EAX)(ptregs)
	    ELSE
		call SYMBOL_NAME(syscall_trace)

		/* push parameters */
		leal	-PTREGS_SIZE(%esp), %esp
		movl	OFFS_PTREGS(ptregs), tmp1
    		movl	(OFFS_PTREGS+4)(ptregs), tmp2
		movl	tmp1, (%esp)
    		movl	tmp2, 4(%esp)
		movl	(OFFS_PTREGS+8)(ptregs), tmp1
    		movl	(OFFS_PTREGS+12)(ptregs), tmp2
		movl	tmp1, 8(%esp)
		movl	(OFFS_PTREGS+16)(ptregs), tmp1
    		movl	tmp2, 12(%esp)
		movl	tmp1, 16(%esp)
		
		call SYMBOL_NAME(sys_call_table)(,%ebx,4)

    		leal	PTREGS_SIZE(%esp), %esp
		movl	%eax,	(OFFS_PTREGS+OFFS_EAX)(ptregs)

    		call SYMBOL_NAME(syscall_trace)
	    ENDIF
    ENDIF	    
    IFNZ    current, $SYMBOL_NAME(task) /* task 0 can't have signals */
	movl	blocked(current), %ecx
	movl	%ecx,	%ebx
	notl	%ecx
	andl	signal(current), %ecx
	IFNZ
	    addl    $OFFS_PTREGS, ptregs
	    pushl   ptregs
	    pushl   %ebx
	    call SYMBOL_NAME(do_signal)
	    leal    8(%esp), %esp
	ENDIF
    ENDIF
    xorl    %eax, %eax

sys_call .REG	(%xxx1)

ptregs	.REG	(%xxx2)
current	.REG	(%xxx3)
tmp1	.REG	(%xxx4)
tmp2	.REG	(%xxx5)


    
.ENDM    

