.MACRO HANDLE_SPECIAL_REGION
    IFA	%eax, $0x80000000
	/* special area */
/*	ke "special area (pre)" */
	pushl	%edx
    	pushl	%eax
    	call	SYMBOL_NAME(l4_handle_special_region)
	orl %eax, %eax
	jz 1f
	    movl    %eax, %ebx
	    jmp	2f
1:  
	    ke	"error in special area"
2:  
    	popl	%eax
	popl	%edx
/*    	ke "special area (post)"  */  
    ENDIF
.ENDM    
    
/*
    PRE:	
	edx:	virtual address
    
    POST:
	edx:	virtual address
	eax:	physical address
	esi:	ptab
	edi:	ptab_index
    
    SCRATCH:	
	ecx		
*/
.MACRO PARSE_PTABS 
    movl    %edx, %eax	    /* \virt_addr, pdir_index */
    movl    %edx, %edi	    /* \virt_addr, \ptab_index */

    shrl    $22, %eax
    movl    SYMBOL_NAME(current_pdir), %esi

    shrl    $12, %edi	    /* extract ptab offset (1. remove offset within page) */
    movl    (%esi, %eax, 4), %esi   /* load ptab address */
    andl    $0x3ff, %edi	    /* extract ptab offset */
				    /* (2. remove pdir index) */
    movl    %esi, %ecx 
    andl    $0xfffff000, %esi

    testb   $1, %cl
    jz	    2f		    /* ptab present ? */

    movl    (%esi, %edi, 4), %eax

    testb    $1, %al	    /* page present ?*/ 
    IFNZ
	testb	$2, %dl	    /* read access ?*/
	IFZ
	    /* read acccess and page  present */
	    movl    $(12 * 4), %ebx
	    andl    $0xfffff000, %eax
	    orl	    $0x20, (%esi, %edi, 4)   /* emulate accessed bit */
	    addl    %eax, %ebx
	    jmp	    3f
	ELSE
	    /* write access, page present */
	    testb   $2, %al /* page writable ?*/
	    jz	1f /* IFNZ */
		/* page present and writable */
		movl    $(12 * 4 + 2), %ebx
		andl    $0xfffff000, %eax
		/* emulate dirty and accessed bit */
    		orl	$0x60, (%esi, %edi, 4) 
		addl    %eax, %ebx
		jmp	3f
1:  	    /* ELSE */
		/* page present, but not writable */
		movl	$(PF_EUSER + PF_EWRITE + PF_EPROTECTION), %eax
		stc
		jmp	    4f
	    /* ENDIF */    
    	ENDIF
    ELSE
	/* page not present */
2:	/* pagetable not present */
	testb	$2, %dl	    /* read access ?*/
	IFZ
	    /* not present, read access */
	    movl   $(PF_EUSER + PF_EREAD + PF_ENOTPRESENT), %eax
	    stc
	    jmp	    4f
	ELSE
	    /* not present, read access */
	    movl   $(PF_EUSER + PF_EWRITE + PF_ENOTPRESENT), %eax
	    stc
	    jmp	    4f
	ENDIF
    ENDIF
3:
    orl	%eax, %eax
4:     
.ENDM        

/*
    PRE:    
	edx:	faulting address
	ebx:	faulting eip
	ebp:	current	
	
    POST:   
	eax == 0:    No error
	    ecx :    short fpage msg
	    ebx :    fpage
	    edx :    offset
	eax ==-1:    Error
    SCRATCHED:	
	all except ebp
*/    
    
        
.MACRO HANDLE_PAGE_FAULT virt_addr, f_eip, msg, error
    IFB	%edx, $0xa0000000
	PARSE_PTABS 
	IFC
	    /* page not present or not writable */
/*	    pusha*/
    	    pushl   %eax
	    pushl   %edx
	    call    SYMBOL_NAME(l4_do_page_fault)
	    popl    %edx
	    popl    %eax
/*	    popa*/
	    PARSE_PTABS
	    IFC
/*		ke	"page not found :   (" */
		movl    $-1, %eax
	    ELSE
		HANDLE_SPECIAL_REGION
		xorl	%eax, %eax
		movl    $2, %ecx
	    ENDIF
	ELSE
	    HANDLE_SPECIAL_REGION
    	    xorl	%eax, %eax
	    movl    $2, %ecx
	ENDIF
    ELSE
	movl    %edx, %esi
	andl    $0xfffff000, %esi
	IFZ	%esi, $0xa0008000
	    /* emulib */
    	    movl	$(SYMBOL_NAME(emu_lib_text) + (12 * 4)), %ebx
	    jmp	7f
	ENDIF
	IFZ	%esi, $0xa0000000
	    /* exclusive page */
    	    movl    $(12 * 4 + 2), %ebx
	    addl    OFFS_EXCLUSIV_PAGE(%ebp), %ebx
	ELSE
#if 0
    	    ke "wrong access"
#endif
	    pushl   %edx
	    call    SYMBOL_NAME(seg_fault_above_task_size)
	    popl    %edx
	    movl    $-1, %eax
	    jmp 8f	   
    	ENDIF    
7:
	xorl	%eax, %eax
	movl    $2, %ecx
8:      
    ENDIF      
.ENDM        
    
    
    
