/* $Id: l4_idle.S,v 1.9 1997/08/21 15:03:50 jw5 Exp $ */

#include <asm/ptrace.h> /* ptregs , offsets */
#include <asm/processor.h> 
#include "../include/task.h"
#include "../include/exclpage.h"
#include "../include/gasp.h"	
#include <linux/sys.h>
#include <linux/linkage.h>
#include <asm/segment.h>
    
/* send mantisse = 0, send exp <> 0 => send timeout 0  */
#define PF_EUSER (4)
#define PF_EWRITE (2)
#define PF_EREAD (0)
#define PF_EPROTECTION (1)
#define PF_ENOTPRESENT (0)


/*          
#define DEBUG_WATCH_SP         
#define DEBUG_PRINT_SWITCH
#define	COUNT_EVENTS    
#define COUNT_SYSTEM_CALLS
*/
    
            
/* #define	MEASURE_SYSCALL_PATH */  
#ifdef	MEASURE_SYSCALL_PATH
#define OFFS_SERVER_START 16
#define OFFS_SERVER_STOP 20    
#include "../include/perform.h"
#endif
 
.MACRO ko text
/* #define DEBUG_IDLE_KO*/
#ifdef DEBUG_IDLE_KO    
        int $3
	cmpb	$\text, %al
#endif    
.ENDM

.MACRO real_ko text
        int $3
	cmpb	$\text, %al
.ENDM

.file	"l4_idle.S"
last_pf:    .long 0

#ifdef SCHEDULE_AFTER_BH
bh_count:    .long 5    
#endif
    
#include "syscall.S"
#include "pagefault.S"
    	
    
    
    
        /*
Note:	If we need to reschedule, we simply call schedule. Schedule
	will activate either a sleeping process, a process to be
	killed or sys_idle. If we return from schedule we have
	received a SIG_KILL signal. We have to check
	under_kernel_control and the signal set to be shure about what
	has happend.
	
	Every process has a special activation frame on top of its own
	stack. It looks like follows:

				idle process	    normal process

    	kernel_stack + 0xffc    myself.high		myself.high
	kernel_stack + 0xff8    myself.low		myself.low
	kernel_stack + 0xff4    __idle_loop		sig_kill()
    
	tss.kernel_sp of a process on user level points directly to
	kernel_stack + 0xff4. If we receive a message and need to
	switch to the associated process we use tss.kernel_stack
	instead of tss.kernel_sp. If we use schedule to select a new
	process and we return from schedule it can only mean, someone
	has send us SIG_KILL, because we was selected by schedule and
	not due to an incoming user request.

    sys_idle implements the following algorithm:

    REPEAT
	IF reschedule needed
	    schedule
	    CONT
	ELSE
	    wait for a message
	    IF	ipc ok
		IF  wakeup message (msg from thread within kernel task)
		    send reply
		    schedule
		    CONT
		ELSE
		    lookup process
		    IF	process expects system call
			switch to process (never returns)
		    ELSE
			ke  "unexpected system call"
			CONT
		    ENDIF
		ENDIF
	    ELSE
		ke  "wait error"
	    ENDIF
    	ENDIF
    ENDR

    dispatch message implements the following algorithm:

    REPEAT
	REPEAT
	    save client id
	    IF	message from emulation library
		IF system call
		    set tss.under_kernel_control
		    dispatch system call
		    IF process not under kernel control anymore
			EXIT (no reply necessary, reschedule)
		    ENDIF
		    reset tss.under_kernel_control		    
		ELSE (exception)
		    set tss.under_kernel_control
		    handle exception
    		    reset tss.under_kernel_control    
		ENDIF
	    ELSE (page fault)
		set tss.under_kernel_control
		handle page fault
    		reset tss.under_kernel_control
	    ENDIF

    	    restore client id
	    IF error while message dispatch
		EXIT (no reply, reschedule)
	    ENDIF
	    begin atomar
	    IF	reschedule not needed
		mark idle sleeping
		send reply and wait for next order
		mark idle activ
		end atomar
		IF ipc ok
		    IF not wakeup message
			lookup process
			IF message for me
			    CONT (dispatch message)
			ELSE
			    IF process expects system call
				switch to process
				CONT (dispatch message)
			    ELSE
				ke  "process doesn't expect system call"
				EXIT (reschedule)
			    ENDIF
			ENDIF
		    ELSE
			send reply
			EXIT (reschedule)
		    ENDIF			
		ELSE
		    ke "error in reply and wait"
		    EXIT (reschedule)
		ENDIF
	    ELSE
		end atomar
		send reply
		IF ipc ok
		    EXIT    (reschedule)
		ENDIF
		ke  "send error"
		EXIT	(reschedule)
	    ENDIF
	ENDR
	schedule
	ke  "sig_kill received?"
	handle sig_kill
    ENDR
*/
.MACRO SWITCH_CTXT function
/*	
    Precond:	
		ebp:	new current
		(esp):	return address used by schedule()/switch_to()
			if we remove the page number esp should have 
			an offset of 0xff4
    Postcond:
		- esp, current, current_tss, current_pdir 
		   set according to new context
		- esp of old context written to old_tss.kernel_sp
    Scratched:	
		eax, ecx
*/
#ifdef DEBUG_PRINT_SWITCH
	IFNZ	print_switch, $0
	    pusha
	    pushl   %ebp
	    call    SYMBOL_NAME(\function)
	    popl    %ebp
	    popa
	ENDIF
#endif
/* #define WATCH_RUNQUEUE */
#ifdef WATCH_RUNQUEUE
	pusha
	pushl	%ebp
	call	SYMBOL_NAME(watch_current)
	popl	%ebp
	pushl	SYMBOL_NAME(current_set)
	call	SYMBOL_NAME(watch_current)
	popl	%ebp
	popa
#endif

    
        movl	SYMBOL_NAME(current_set), %eax	 # get current
        movl    OFFS_PAGEDIR(%ebp), %ecx	 # get pdir of current proc
    
        movl    %ebp,   SYMBOL_NAME(current_set) # set current_set 
        movl    %ecx,   SYMBOL_NAME(current_pdir)# set current_pdir

    	movl    %esp, OFFS_KERNEL_ESP(%eax)
        movl    OFFS_KERNEL_STACK(%ebp), %esp    # get esp of current proc 
        
	addl	$4, %esp			 # remove return address

#ifdef DEBUG_WATCH_SP
	movl    OFFS_KERNEL_ESP(%eax), %ecx
	andl	$0xfff, %ecx
	IFNZ	%ecx, $0xff4 
	    ke	"wrong esp?"
	ENDIF
#endif    
.ENDM    

ENTRY(l4_idle)
    /* adjust stack */
    andl	$0xfffff000, %esp 
    addl	$(0x1000 - 8), %esp
    movl	%esp, %eax
    subl	$4, %eax
    movl	SYMBOL_NAME(current_set), %edx
    movl	%eax, OFFS_KERNEL_STACK(%edx)
__idle_loop:	
/*    ke	"entering idle loop"	*/
    REPEAT
        cli
idle_bottom_half_loop:
/* 	real_ko 0x42 */

	movl SYMBOL_NAME(bh_mask),%eax
	andl SYMBOL_NAME(bh_active),%eax
	je idle_no_bottom_half_active
	
/*	ke "start idle_handle_bottom_half" */
    
	incl SYMBOL_NAME(intr_count)
      	sti
    	call SYMBOL_NAME(do_bottom_half)
	cli
    	decl SYMBOL_NAME(intr_count)
    
/*        ke "end idle_handle_bottom_half" */

    	jmp idle_bottom_half_loop
idle_no_bottom_half_active:
    
        IFNZ	SYMBOL_NAME(need_resched), $0
	    /* reschedule needed, enable interrupts and call schedule */
	    sti
	    ko	0x43
    	    call    SYMBOL_NAME(schedule)
	    CONT
	ELSE
	    /* nothing to do, wait for order or wakeup */
	    movl    $1, SYMBOL_NAME(idle_sleeping)
	    xorl    %ecx, %ecx		
	    leal    -1(%ecx), %eax
    	    leal    1(%ecx), %ebp
	    int	    $0x30

	    orl	    %eax, %eax
	    movl    %esi, %ecx

	    movl    $0, SYMBOL_NAME(idle_sleeping)
	    IFZ

		shrl	$(17-2), %ecx
	        movl	SYMBOL_NAME(current_set), %eax


    	        andl    $(TASKNO_MASK >> (17-2)), %ecx

	        sti
    
	        IFNZ	%ecx, SYMBOL_NAME(kernel_taskno)
		    movl    SYMBOL_NAME(task_to_proc)(%ecx), %ebp
#ifdef MEASURE_SYSCALL_PATH
#warning	measurement overhead
		movl	%edx, %ecx
		rdtsc
		movl	OFFS_EXCLUSIV_PAGE(%ebp), %edx
		orl 	%edx, %edx
		jz  1f
		    movl	%eax, OFFS_SERVER_START(%edx)
		    movl	%ecx, %edx
1:  
#endif         

    		    IFZ	    OFFS_UNDER_KERNEL_CONTROL(%ebp), $0
    			/* switch to associated thread */
 			pushl	$__idle_loop
    			SWITCH_CTXT print_idle_switch
			jmp dispatch_msg
		    ELSE
			ke "l4_idle: under control"
			CONT
		    ENDIF
		ELSE
		    /* hmm, it was a wakeup, call send reply and reschedule */
/*		    kd	"wakeup msg rcvd" */
		    xorl    %eax,%eax
		    leal    -1(%eax),	%ebp
		    int	    $0x30
		    CONT
		ENDIF
	    ELSE
		/* hmm, something went wrong, for some reason our ipc failed */
		ke "l4_idle: ipc failed"
		CONT
	    ENDIF
	ENDIF
    ENDR
    ke "l4_idle: never reached"


/* ------------------------------------------------------------------
     
    dispatch message dispatches an incoming message to its respective
    kernel coroutine. Then the result is send to the process.
    If there is no other activity going on in the kernel, the
    dispatch_msg waits for a new order. Otherwise it calls schedule to
    switch to another activ kernel coroutine.
    
    PRECONDITION:	edx,ebx:    message
    			esi,edi:    source id
			current, current_tss and current_pdir point
			to context of current process  
   ------------------------------------------------------------------ */
handle_bottom_half:
/*	ke "start handle_bottom_half" */
	incl SYMBOL_NAME(intr_count)
	pushl	%edx
	pushl	%ecx

bottom_half_loop:
/* 	real_ko 0x42 */
      	sti
    	call SYMBOL_NAME(do_bottom_half)
	cli
	movl SYMBOL_NAME(bh_mask),%eax
	andl SYMBOL_NAME(bh_active),%eax
	jne bottom_half_loop
	
	popl	%ecx
	popl	%edx
    	decl SYMBOL_NAME(intr_count)
/*    	ke "end handle_bottom_half" */
#ifdef SCHEDULE_AFTER_BH
    	decl	bh_count
	jnz 1f
	movl	$2, bh_count
    	movl	$1, SYMBOL_NAME(need_resched)
    1:
#endif    
	jmp __cont_ret_from_syscall

dispatch_msg:	
REPEAT
    REPEAT
	/* dispatch message */
	pushl	%esi
	pushl	%edi	/* save client id */
	movl	$1, OFFS_UNDER_KERNEL_CONTROL(%ebp)
    
	IFZ	%edx, $EMULIB_SYSCALL
		/* ke	"syscall" */

		DISPATCH_SYSCALL

    		/* if we aren't under kernel control anymore (i. e. after 
		   execve), we have to call schedule to activate another 
		   process or idle */
    		IFZ	OFFS_UNDER_KERNEL_CONTROL(%ebp), $1
		    xorl	%ecx, %ecx
		    jmp		__end_dispatch
		ELSE
		    call    SYMBOL_NAME(start_thread_really)
		    addl    $8, %esp
		    EXIT
		ENDIF

	ELSE
/*	    IFNZ	%edx, $EMULIB_EXCEPTION*/
	    cmpl    $EMULIB_EXCEPTION, %edx
	    jz	    __exception
    
/*	    page fault */
	    HANDLE_PAGE_FAULT
#ifdef CHECK_ASM_LOOKUP
	    pusha
	    pushl   %ebx
	    pushl   %edx
	    call SYMBOL_NAME(check_lookup)
	    popl    %edx
	    popl    %ebx
	    popa
#endif    
	    orl	    %eax, %eax
    	    jns	    __end_dispatch
    
	    /* segmentation fault, no reply */
    	    movl	$0, OFFS_UNDER_KERNEL_CONTROL(%ebp)
	    popl	%edi
	    popl	%esi
	    EXIT		/* reschedule */
	    
/*	    ELSE*/
__exception:	
		/* ke	"exception" */
		call	SYMBOL_NAME(deliver_signal)
		xorl	%ecx, %ecx
		jmp		__end_dispatch
/*	    ENDIF*/
	ENDIF

	/* deliver result if necessary */
__end_dispatch
	    cli
	    IFZ    SYMBOL_NAME(intr_count), $0
		movl SYMBOL_NAME(bh_mask),%eax
		andl SYMBOL_NAME(bh_active),%eax
		jne handle_bottom_half
	    ENDIF
    
__cont_ret_from_syscall:    
    	    IFNZ    SYMBOL_NAME(need_resched), $0
	    /* save reply parameters (eax, ecx, edx) */
		sti
       		pushl	%eax
		pushl	%ecx
		pushl	%edx
		ko	0x73
		call	SYMBOL_NAME(schedule)
		cli
		popl	%edx
    		popl	%ecx
    		popl	%eax
    	    ENDIF
	    movl	$0, OFFS_UNDER_KERNEL_CONTROL(%ebp)
	    popl	%edi
	    popl	%esi

	    /* send reply and wait for a new order */
    	    movl    $1, 	SYMBOL_NAME(idle_sleeping)

	    movl    $1,		%ebp 	/* open wait */
	    movl    %ecx,	%eax
	    movl    $SYSCALL_TIMEOUT,   %ecx
	    /* ke  "send reply" */
#ifdef MEASURE_SYSCALL_PATH
#warning	measurement overhead
	    pushl   %eax
	    pushl   %edx
	    rdtsc
	    movl    SYMBOL_NAME(current_set), %edx
	    movl    OFFS_EXCLUSIV_PAGE(%edx), %edx
	    orl	    %edx, %edx
	    jz  1f
		movl	%eax, OFFS_SERVER_STOP(%edx)
1:
	    popl    %edx
	    popl    %eax  
#endif         
	    int	    $0x30
#ifdef MEASURE_SYSCALL_PATH
#warning	measurement overhead
	    pushl   %eax
	    pushl   %edx
	    rdtsc
	    movl    SYMBOL_NAME(current_set), %edx
	    movl    OFFS_EXCLUSIV_PAGE(%edx), %edx
	    orl	    %edx, %edx
	    jz  1f
		movl	%eax, OFFS_SERVER_START(%edx)
1:
	    popl    %edx
	    popl    %eax  
#endif         

	    orl	    %eax, %eax
	    movl    %esi, %ecx

	    movl    $0, SYMBOL_NAME(idle_sleeping)
	    IFZ

		shrl	$(17-2), %ecx
	        movl	SYMBOL_NAME(current_set), %eax

    	        andl    $(TASKNO_MASK >> (17-2)), %ecx

	        sti
    
	        movl    SYMBOL_NAME(task_to_proc)(%ecx), %ebp

	        CONTZ	%ebp, %eax /* msg for me, dispatch it */
    
	        IFNZ	%ecx, SYMBOL_NAME(kernel_taskno)
    		    IFNZ	OFFS_UNDER_KERNEL_CONTROL(%ebp), $0    
			/* process doesnt expects sys call, reschedule */
			ke	    "unexpected system call"
			EXIT
		    ENDIF
		    pushl	$SYMBOL_NAME(sig_kill_received)
		    SWITCH_CTXT print_dispatch_switch
		    CONT /* dispatch message */
		ELSE
    		    /* hmm, it was a wakeup, call send reply and reschedule */
		    /* kd	"wakeup msg rcvd" */
		    xorl    %eax,%eax
		    leal    -1(%eax),	%ebp
		    int	    $0x30
		    EXIT
    		ENDIF
	    ELSE
		ke	"reply_and_wait error"
		EXIT
	    ENDIF
    ENDR

    ko	0x73
    movl    $SYMBOL_NAME(init_task), %ebp
    pushl   $SYMBOL_NAME(sig_kill_received)
    SWITCH_CTXT print_dispatch_switch
    call    SYMBOL_NAME(schedule)
    jmp	__idle_loop
ENDR



END
