/*
 * $Id: chead.c,v 1.23 1997/08/20 15:39:03 hohmuth Exp $
 */

/*
 *  linux/arch/i386/head.S
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 */

/*
 *  head.S contains the 32-bit startup code.
 */

/*
 * ported to C because of many unnessecary asm statements in head.S
 */

#include <linux/linkage.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <asm/pgtable.h>
#include <asm/page.h>

#include <l4/kdebug.h>
#include "../include/config.h"
#include "../include/l4_memory.h"
#include "../include/task.h"
#include "../include/user.h"


#define MAX_LINUX_MEM (8 * 1024 * 1024)
asmlinkage void start_kernel(void);

extern int __crt_dummy__, _edata, _end;
extern void ignore_int(void);
extern char x86, hard_math;
extern unsigned long init_user_stack[1024];

extern void set_debug_traps(void); 
extern void breakpoint(void); 

unsigned *pidt=(unsigned *)idt;

struct {
  unsigned short int size __attribute__((packed));
  unsigned long address __attribute__((packed));
} idt_descr = {256 * 8 -1, (unsigned long)idt};

desc_table idt, gdt;

unsigned mem;


static void setup_idt(void)
{
  int idt_low, idt_high,i;

  idt_low=(unsigned)ignore_int & 0xffff;
  idt_high=((unsigned)ignore_int & 0xffff0000) | 0x8e00;

  for(i=0; i<256; i++)
    {
      pidt[i*2]=idt_low;
      pidt[i*2 + 1]=idt_high;
    }

  /*  asm("lidt	(%%eax)\n\t" : : "a" (&idt_descr)); */
}

void setup_paging(void)
{
  /*
    int i;
    unsigned long address;
  */
  /* Map the kernel in low 4 MB for ease of transition (whatever that means 
   * set present/rw/user bits
   * The real head.S maps the kernel to 0xC0000000 because of usage of 
   * segmentregister, but we don't use segment registers 
   * 
   * But I will map it to c000000 too to allow memory management to
   * distinct between kernel and user page tables
   */

  kd_display("setup_paging\\r\\n");

  /* 
   * clear swapper_page_dir and pg0
   */
  memset(swapper_pg_dir, 0, 2 * PAGE_SIZE);
  pgd_val(swapper_pg_dir[0]) = (unsigned)pg0 + 
    (_PAGE_PRESENT | _PAGE_RW | _PAGE_USER);
  pgd_val(swapper_pg_dir[TASK_SIZE >> 22]) = pgd_val(swapper_pg_dir[0]); 

  /* identity map the first 4 MB to 0 and 0xc0000000 
  for(i=0, address=0; i<1024; i++, address+=0x1000)
    {
      switch (request_page_from_sigma0(address))
	{
	case RP_WRITABLE:
	  pg0[i]=address + (_PAGE_PRESENT | _PAGE_RW | _PAGE_USER);
	  break;
	case RP_NOT_WRITABLE:
	  pg0[i]=address + (_PAGE_PRESENT | _PAGE_USER);
	  break;
	case RP_NOT_MAPPED:
	  pg0[i]=address + _PAGE_USER;
	  break;
	}
    }
    */
}

void detect_processor(void)
{
  kd_display("detect processor");
  x86 = 4;	/* We emulate an i486 */
  hard_math=1;  /* And we have a coproc */
}

void linux_startup(void)
{
  /* Attention: no stack variables here as the stack may not have been
     setup correctly yet */

  /*
   * Setup Stack, it's a kind of tricky I think
   */
  init_user_stack[0] = STACK_MAGIC;
  init_user_stack[INIT_USER_STACK_START] = STACK_MAGIC;
  put_l4_id_to_stack((unsigned)init_user_stack, l4_myself());

  asm("movl	%0, %%esp\n\t" 
      : /* No output */ : "g" (&init_user_stack[INIT_USER_STACK_START]));

  /* clear direction flag because of gcc expects that */
  asm("cld");
  kd_display("linux_startup\\r\\n");

  /* clear bss */
  memset(&_edata, 0, (unsigned)&_end - (unsigned)&_edata);

#if 0
  enter_kdebug("set_debug_traps()");
  set_debug_traps(); 
  breakpoint(); 
#endif

  /* check whether our OFFS_TSS assumption is still valid */
  kd_display("checking OFFS_TSS: ");
  if (&(((struct task_struct *)(0))->tss) == (struct thread_struct *)OFFS_TSS)
    kd_display("ok, OFFS_TSS still "str(OFFS_TSS)"\\n\\r");
  else
    enter_kdebug("OFFS_TSS != "str(OFFS_TSS));


  /* copy code of emulation library to special page */
  if ((unsigned long)&emulib_text_end - (unsigned long)&emulib_text_start >
      PAGE_SIZE)
    enter_kdebug("size of emulib > PAGESIZE");

#ifdef __ELF__
  memcpy(emu_lib_text, &emulib_text_start, 
	 (unsigned long)&emulib_text_end - (unsigned long)&emulib_text_start);
#else
  /* XXX dirty hack to handle bad address emulib_text_start for a.out */
  memcpy(emu_lib_text + 0x20, &emulib_text_start, 
	 (unsigned long)&emulib_text_end - (unsigned long)&emulib_text_start);
#endif
  /* create idt */
  {
    extern long idt_table;
    struct entry_t {unsigned short w0, w1,w2,w3;} ;
    struct entry_t *entries = 
      (struct entry_t *)((unsigned long)emu_lib_text + 
			 ((unsigned long)&idt_table - EMULIB_CODE_ADDRESS));
    unsigned short int tmp;
    int i;

    for (i=0; i<20; i++, entries++)
      {
	tmp = entries->w1;
	entries->w1 = entries->w3;
	entries->w3 = tmp;
      }
  }
  
  detect_processor();

  /*
   * Initialize an idt pointing to ignore_int and load it
   */
/*   setup_idt(); */

#if 0
  Init_COM_thread();
#endif

  /* XXX Copy boot_params; I will try to use the real mode 
   * XXX initialization phase of L4 to put the parameters to the zero page
   */

  /* 
   * memcpy(empty_zero_page, boot_params, PAGE_SIZE);
   */ 
 
  setup_paging();

  kd_display("end linux_startup, calling start_kernel\\r\\n");
  start_kernel();
  for(;;);
}

