.\"Warning: don't edit this file. It has been generated by typeset
.\" The next compilation will silently overwrite all changes.
.TH "l4_thread_ex_regs" 1 "27.06.96" "Institut" "User Commands"
.SH NAME
 l4_thread_ex_regs \-  read and write register values of a thread, create a thread

.SH " Synopsis"
.nf
\fB#include <l4/syscalls.h>\fP
.fi
.PP
\fBstatic inline void\fP 
.br
\fBl4_thread_ex_regs(l4_threadid_t \fP \fIdest\fP \fB,
dword_t \fP \fIeip\fP \fB, dword_t \fP \fIesp\fP \fB,
l4_threadid_t \fP \fI*preempter\fP \fB, l4_threadid_t\fP \fI*pager\fP
\fB, dword_t \fP \fI*old_eflags\fP \fB, dword_t\fP \fI*old_eip\fP
\fB, dword_t \fP \fI*old_esp\fP \fB);\fP

.SH " Description"
The \fBl4_thread_ex_regs()\fP system call reads and writes user\-level 
register values of a thread in the current task. Ongoing kernel
activities are not effected. An ipc operation is cancelled or aborted,
however. Setting stack and instruction pointer to different valid
values results in the creation of a new thread. 
.SH " Arguments"
.IP "\fIdest\fP"
The identifier of the destination thread.
.IP "\fIeip\fP"
The new instruction pointer of the thread. It must
point into the user\-accessible part of the address space. The existing
instruction pointer is not modified if \fB0xFFFFFFFF\fP is given. 
.IP "\fIesp\fP"
The new stack pointer for the thread. It must point into the
user\-accessible part of the address space. The existing stack
pointer is not modified if \fB0xFFFFFFFF\fP is given. 
.IP "\fI*preempter\fP"
Defines the internal preempter used by the thread. The
current preempter id is not modified if \fBL4_INVALID_ID\fP is given. 
.IP "\fI*pager\fP"
Defines the pager used by the thread. the current pager id
is not modified if \fBL4_INVALID_ID\fP is given. 
.IP "\fI*old_flags\fP"
Flags of the thread.
.IP "\fI*old_eip\fP"
Old instruction pointer of the thread.
.IP "\fI*old_esp\fP"
Old stack pointer of the thread.
.SH " Return Values"
The thread id of the current thread is returned.
.SH " See Also"
 l4_fpage_unmap ,  l4_myself ,  l4_nchief ,  l4_thread_switch ,  l4_thread_schedule ,  l4_task_new  
