.\"Warning: don't edit this file. It has been generated by typeset
.\" The next compilation will silently overwrite all changes.
.TH "rmgr" 1 "1997/12/09" "DROPS" "User Commands"
.SH NAME
 rmgr \- L4 System Resource Manager

.SH "Synopsis"
\fBrmgr\fP [ \fB\-nopentium\fP ] [ \fB\-sigma0\fP ] 
[ \fB\-configfile\fP | \fIconfiguration_directives\fP ... ]
.SH "Description"
RMGR is a simple system resource manager for the L4 microkernel. It
also functions as an easy\-to\-use system bootstrapper. It is invoked
at boot time from a boot loader (see section Booting).
.PP
RMGR acts as a pager for the tasks it starts. It emulates the sigma0
protocol for them (L4 Reference Manual, Appendix B). Moreover, it
manages the following system resources: main memory, irq lines and L4
task numbers. Client tasks can request access to these resources
using a proprietary protocol, the supervisor protocol (see  rmgr_api ).
.PP
RMGR can be configured by specifying configuration directives either
on the command line or in a configuration file. Which alternative is
used depends on the following command line argument:
.IP "\fB\-sigma0\fP"
Use the ELF binary loaded as the first boot module
after the L4 kernel as L4's Sigma0 server.
.IP "\fB\-configfile\fP"
Use the configuration file loaded as the first
boot module after the L4 kernel (and after Sigma0, if \fB\-sigma0\fP is also used) to find configuration directives.
.IP
If this parameter is not specified, configuration directives are taken
directly from the command line instead.
.IP "\fB\-nopentium\fP"
Assume we are running on L4 486 even if we
actually run on L4/Pentium. 
.IP
RMGR tries to detect the L4 version during startup to find out about
the services the L4 kernel and its servers provide. At the
moment the only difference that must be handled is the 4MB
page extension of L4/Pentium. All other L4/Pentium specific
features are no\-ops at L4/486 and therefore don't need any
special treatment. If we use L4/pentium but want to be able
to simulate L4/486 within respect to 4MB page tables, \fB\-nopentium\fP forces RMGR to think it is running on
L4/486. 
.PP
See section Configuration for information on configuration directives.
.SH "Booting"
RMGR is compatible with the Multiboot standard proposal. It should be
started as a boot kernel using a Multiboot\-compliant boot loader like
GRUB. The L4 \(*m\-kernel should be loaded as the first boot module, and
the RMGR config file (if required) as the second boot module. Any
boot servers intended to be started by RMGR at boot time should be
loaded as further boot modules.
.PP
Here is a sample GRUB configuration file (menu.lst) which accomplishes
this:
.RS
.sp
.nf
\fB# RMGR is the boot kernel
kernel= (fd0)/rmgr \-configfile
# L4 must be the first boot module
module= (fd0)/grubboot.img nowait
# The RMGR config file (if any) must come second
module= (fd0)/rmgr.cfg
# boot server tasks follow
module= (fd0)/glinux.gz root=/dev/sda5
module= (fd0)/hello\fP
.fi
.RE
.sp
.PP
After having been loaded in this way, the boot loader will first
activate an RMGR initialization routine which first initializes L4's
boot configuration table according to section 2.9 of the L4 Reference
Manual. (This renders previous methods of patching the boot table
before booting in the boot image on disk obsolete.) RMGR makes sure
it will be the first user task running under L4 (the \fIbooter task\fP
or \fIroot task\fP in L4\-speak).
.PP
Because of deficiencies of the L4 \(*m\-kernel, RMGR also parses and
processes L4's command line (containing "\fBnowait\fP" in the example
above). RMGR understands the following space\-separated directives:
.IP "\fBnowait\fP"
Don't invoke the L4 kernel debugger L4KD
interactively upon boot.
.IP "\fBhercules\fP"
Use the monocrome (Hercules or MGA) graphics
adapter for the console dialog with L4KD. Normally, if both a color
and a monocrome display are attached to the system, L4KD defaults to
the color display.
.IP "\fBirq0\fP"
Force L4 to allow access to irq0, the interrupt
request used by the high resolution timer. Since there are
plans to use this timer within L4 to implement high
resolution and short time wakeups the usage of this option
is strongly discouraged. Use it at your own risc, since
it can vanish at any time.
.IP "\fBboothack\fP"
Work around a bug in very old versions of L4 which
didn't allow them to be booted in protected mode. This flag is
required for all versions of L4 from before January 1997.
.PP
Once running under L4, RMGR parses its configuration data (if supplied) and
then starts the executable images loaded as further boot modules as
child tasks.
.PP
Except for the RMGR configuration file (and modules intended to be
passed to sub\-tasks as parameters), all boot modules (including
the L4 \(*m\-kernel) must be ELF binaries linked to the absolute RAM
address they should be loaded into. They don't have to be
multiboot\-compliant (RMGR doesn't interpret multiboot data structures
imbedded into them) but they \fIwill\fP be started in a
multiboot\-compliant way, enabling them to make use of a \fBmultiboot_info\fP data structure containing a command line, the
machine's RAM size, and a list of multiboot modules (loaded by the
boot loader and passed on by RMGR using the \fBmodule\fP option
described below).
.SH "Configuration"
The configuration data can be specified on RMGR's command line or
in a configuration file (see section Description).
.PP
When using a configuration file, the first line of the file should
contain only the following text:
.RS
.sp
.nf
\fB#!rmgr\fP
.fi
.RE
.sp
.PP
In the configuration text, whitespace and newlines are ignored, as is
text between the comment character, "\fB#\fP", and the end of the
line. Here is the configuration syntax:
.RS
.sp
\fIconfigfile\fP := [ \fIrule\fP ... ] [ \fBend\fP ]
.PP
\fIrule\fP := \fItaskrule\fP | \fIglobalrule\fP | \fIdebugrule\fP

.PP
\fItaskrule\fP := \fBtask\fP [ \fBmodname\fP \fIstring\fP | \fInumber\fP 
| \fBrmgr\fP | \fBsigma0\fP ] [ \fIconstraint\fP | \fIbootparam\fP ] 
\&... [ \fImodule\fP ] ...
.PP
\fImodule\fP := \fBmodule\fP [ \fBmodname\fP \fIstring\fP ]
.PP
\fIconstraint\fP := \fBchild\fP \fInumconstraint\fP ... | \fBmemory\fP \fInumconstraint\fP | \fBhigh_memory\fP \fInumconstraint\fP | \fBsmall\fP \fInumconstraint\fP | \fBirq\fP \fImaskconstraint\fP ...
.PP
\fInumconstraint\fP := \fBmax\fP \fInumber\fP | \fBin [\fP \fInumber\fP \fB,\fP \fInumber\fP \fB]\fP

.PP
\fImaskconstraint\fP := \fBmask\fP \fInumber\fP | \fInumconstraint\fP

.PP
\fIbootparam\fP := \fBlog_mcp\fP \fInumber\fP | \fBboot_mcp\fP \fInumber\fP | \fBboot_priority\fP \fInumber\fP | \fBboot_small\fP \fInumber\fP 
.PP
\fIglobalrule\fP := \fBsmall_space_size\fP \fInumber\fP

.PP
\fIdebugrule\fP := \fBbootwait\fP | \fBverbose\fP | \fBdebug\fP | \fBdebug_log\fP \fInumber\fP \fInumber\fP

.RE
.sp
.PP
The configuration text consists of a sequence of directives;
currently, the following types of directives are known: \fBtask\fP, \fBsmall_space_size\fP, \fBbootwait\fP, \fBverbose\fP, \fBdebug\fP, \fBdebug_log\fP, and \fBend\fP.
.PP
The sequence of \fBtask\fP
directives corresponds to the sequence of bootstrap tasks loaded as
boot modules. The \fBmodname\fP parameter can be used to verify that
the correct module is addressed: If \fIstring\fP is not contained in
the "\fBmodule=\fP" specification, an error is signaled.
Alternatively, the \fBtask\fP directive can be qualified by an explicit
task number or one of the task specifiers \fBrmgr\fP or \fBsigma0\fP.
.PP
For each task, directives can be given to constrain the set of system
resources the task can request from RMGR. For subtasks (\fBchild\fP)
and memory, these constraints are the maximal number of units that can
be acquired and the numeric range the units must be part of. For IRQ
lines, it is additionally possible to specify a mask which exactly
defines which IRQs can be requested. Also, certain bootstrap
parameters can be specified.
.PP
All constraints specified for a given resource type are logically
AND'd, i.e., all constraints must be true for a resource address to be
requestable for the corresponding task.
.PP
Tasks can also be passed a list of multiboot modules, to be specified
using one or more \fBmodule\fP options.
.PP
The \fBsmall_space_size\fP directive defines the minimal size of the
system's small address spaces. If not specified, the system will run
with only large address spaces.
.PP
The \fBbootwait\fP directive can be used to cause RMGR to pause
before actually starting to serve the bootstrapped tasks. It can be
used to review the console messages printed by RMGR before they scroll
off the screen.
.PP
The \fBverbose\fP, \fBdebug\fP, and \fBdebug_log\fP directives can
be used to modify RMGR's logging and debugging behaviour:\fBverbose\fP enables logging of all run\-time error messages to the
console, \fBdebug\fP enables an invokation of the L4 kernel debugger
on run\-time errors, and \fBdebug_log\fP allows to define which
protocol should be logged. For further information, UTSL.
.PP
The \fBend\fP directive marks the end of the configuration file. All
text appearing after \fBend\fP is ignored by RMGR.
.PP
\fIString\fPs are \fB"\fP\- or \fB'\fP\-separated literals (which
cannot contain the separation character). \fINumber\fPs can be given
in decimal, hexadecimal or octal format (using C syntax).
.PP
Here is an example configuration file:
.RS
.sp
.nf
\fB#!rmgr

task modname "glinux"
child max 512 in [10, 531]
memory max 0x01000000 in [0, 0x01000000]
irq mask 0xffffffe7

end\fP
.fi
.RE
.sp
.SH "Bugs"
Currently, I/O flexpages cannot be constrained.
.PP
This manual page:
.IP "\(bu"
should explain what state is managed for each resource type
.SH "See Also"
 l4kd 

.PP
L4 Reference Manual
.PP
Guidelines for Developing OS Servers on Top of L4
.PP
 http://www.uruk.org/grub/ GRUB, the Grand Unified Bootloader

.PP
 http://www.uruk.org/grub/boot\-proposal.html Multiboot
standard proposal
