#ifndef __L4_SERVER_RMGR_H__
#define __L4_SERVER_RMGR_H__

#include <l4/server/proto.h>

#define RMGR_LTHREAD_PAGER (0)
#define RMGR_LTHREAD_SUPER (1)

#define RMGR_RMGR (0)		/* PROTOCOL: rmgr meta protocol */
#define RMGR_RMGR_PING (0xf3)	/* ping -- returns ~arg in d2 */

#define RMGR_RMGR_MSG(action, arg) L4_PROTO_MSG(RMGR_RMGR, (action), (arg))

#define RMGR_MEM (1)		/* PROTOCOL: memory operations */
#define RMGR_MEM_FREE (1)	/* free an fpage */

#define RMGR_MEM_MSG(action) L4_PROTO_MSG(RMGR_MEM, (action), 0)

#define RMGR_TASK (2)		/* PROTOCOL: task operations */
#define RMGR_TASK_ALLOC (1)	/* allocate task number */
#define RMGR_TASK_GET (2)	/* allocate specific task number */
#define RMGR_TASK_FREE (3)	/* free task number */
#define RMGR_TASK_CREATE (4)	/* create a task XXX */
#define RMGR_TASK_DELETE (5)	/* delete a task */
#define RMGR_TASK_SET_SMALL (6)	/* set a task's small address space number */
#define RMGR_TASK_SET_PRIO (7)	/* set a task's priority */
#define RMGR_TASK_GET_ID (8)	/* get task id by module name */

#define RMGR_TASK_MSG(action, taskno) \
  L4_PROTO_MSG(RMGR_TASK, (action), (taskno))

#define RMGR_IRQ (3)
#define RMGR_IRQ_GET (2)	/* allocate an interrupt number */
#define RMGR_IRQ_FREE (3)	/* free an interrupt number */

#define RMGR_IRQ_MSG(action, intno) \
  L4_PROTO_MSG(RMGR_IRQ, (action), (intno))

#endif
