/*
 *  Insert BSD-style license here
 */

/*
 *  MultiBoot Header description
 */

struct multiboot_header
{
  /* Must be MULTIBOOT_MAGIC - see below.  */
  unsigned magic;

  /* Feature flags - see below.  */
  unsigned flags;

  /*
   * Checksum
   *
   * The above fields plus this one must equal 0 mod 2^32.
   */
  unsigned checksum;

  /* These are only valid if MULTIBOOT_AOUT_KLUDGE is set.  */
  unsigned header_addr;
  unsigned load_addr;
  unsigned load_end_addr;
  unsigned bss_end_addr;
  unsigned entry_addr;
};

/*
 * The entire multiboot_header must be contained
 * within the first MULTIBOOT_SEARCH bytes of the kernel image.
 */
#define MULTIBOOT_SEARCH            8192
#define MULTIBOOT_FOUND(addr, len) \
  (!((addr) & 0x3) && ((len) >= 12) && (*((int *)(addr)) == MULTIBOOT_MAGIC) \
   && !(*((unsigned *)(addr)) + *((unsigned *)(addr+4)) \
	+ *((unsigned *)(addr+8))) \
   && (!(MULTIBOOT_AOUT_KLUDGE & *((int *)(addr+4))) || ((len) >= 32)))

/* Magic value identifying the multiboot_header.  */
#define MULTIBOOT_MAGIC	            0x1BADB002

/*
 * Features flags for 'flags'.
 * If a boot loader sees a flag in MULTIBOOT_MUSTKNOW set
 * and it doesn't understand it, it must fail.
 */
#define MULTIBOOT_MUSTKNOW          0x0000FFFF

/* currently unsupported flags...  this is a kind of version number.  */
#define MULTIBOOT_UNSUPPORTED       0x0000FFFC

/* Align all boot modules on i386 page (4KB) boundaries.  */
#define MULTIBOOT_PAGE_ALIGN        0x00000001

/* Must pass memory information to OS.  */
#define MULTIBOOT_MEMORY_INFO       0x00000002

/* This flag indicates the use of the other fields in the header.  */
#define MULTIBOOT_AOUT_KLUDGE       0x00010000

