.\"Warning: don't edit this file. It has been generated by typeset
.\" The next compilation will silently overwrite all changes.
.TH "l4kd" 1 "1997/08/06" "DROPS" "User Commands"
.SH NAME
 l4kd \- The L4 Kernel Debugger

.SH "Synopsis"
\fBL4KD\fP

.SH "Description"
Jochen Liedtke's L4 microkernel comes with a minimalistic kernel
debugger, L4KD, which is primarily intended for debugging the \(*m\-kernel
but also allows examining the kernel and user state of user tasks.
.PP
L4KD is not a symbolic debugger. The programmer using it should have
a good understanding of the x86 architecture and should have an
assembler or disassembler listing of whatever he needs to debug next
to him to make sense of what's displayed.
.PP
When invoked, L4KD presents the user with its prompt, "\fBL4KD:\fP",
and then waits for the user to enter single\-character commands (see
the section on commands).
.PP
L4KD is automatically invoked upon each boot of the L4 \(*m\-kernel to
give the user a chance to set any initial breakpoints, etc. Normally,
the user has to enter an explicit "\fBg\fP" command (see below) to
get the system going.
.PP
Once the system is running, there are several ways to invoke L4KD:
.IP "\(bu"
The CPU runs into a machine breakpoint previously set using L4KD.
.IP "\(bu"
A thread executing in kernel mode catches an unhandled exception. 
(This suggests a bug in the L4 \(*m\-kernel.)
.IP "\(bu"
A privileged user thread catches an unhandled exception. (User
threads can handle exceptions by installing a private LDT.)
(See also the Bugs section.)
.IP "\(bu"
The \(*m\-kernel's timer interrupt handler can monitor the keyboard
and/or a serial port. If the monitoring is enabled (see the
description of the ,,\fBI\fP'' command below) and an Escape character
is detected, L4KD is entered.
.PP
L4KD can be controlled using the system's video console or using a
serial terminal\(emsee the description of the "\fBV\fP" command
below.
.SH "Commands"
L4KD commands are single or double\-character mnemonics; the case is
significant. Commands are invoked automatically once all required
arguments have been typed in; commands expecting no arguments are invoked
immediately. There is no command line editing.
.PP
Typing in arguments can be finished by typing Return or Space.
.PP
In the following list of commands, the following argument types are
used (all numbers must be given in hexadecimal representation):
.IP "\fIaddr\fP"
a virtual (or I/O) address.
.IP "\fIsize\fP"
width of a memory access in bytes; can be 1, 2, or 4.
.IP "\fIthreadid\fP"
an internal 2\-byte (\(<=4 hex digits) thread reference
number.
.IP "\fIlong_threadid\fP"
an external 4\-byte (>4 hex digits) thread
reference number; this is the low word of the external 8\-byte thread
ids.
.IP "\fItasknr\fP"
a task number (0\(en1ff).
.IP "\fIthreadnr\fP"
a thread number within a single task
(0\(en7f).
.IP "\fIframenr\fP"
a physical page frame number.
.IP "\fIexcpnr\fP"
an exception number.
.IP "\fIerrcode\fP"
an exception error code.
.PP
Now for the list of commands itself:
.IP "\fB?\fP"
Show a short one\-screen help.
.IP "\fBg\fP"
Resume execution.
.IP "Shift+Num"
Reboot the machine. (Only works on the system console,
not via a serial line.)
.IP "\fBa\fP [ \fIaddr\fP ]"
Show absolute base addresses of the L4
kernel modules. Without an argument, shows all modules. With an
4\-digit address, shows the module containing the code located at the
address.
.IP
The module base addresses can be useful for setting a breakpoint base
address using ,,\fBbb\fP'' when debugging a particular kernel module;
however, please note that the memory is mapped in at kernel virtual
address 0xf0000000, so this value needs to be added to the module base
address.
.IP "\fBb\fP"
Show currently set machine breakpoint. (Please always
use ,,\fBb\fP Return'' instead of ,,\fBb\fP Space''\(emsee the Bugs
section).
.IP "\fBb\-\fP"
Delete a currently set machine breakpoint, and reset all
breakpoint restrictions.
.IP "\fBbb\fP [ \fIbaseaddr\fP ]"
Set a base address for future
breakpoints, or (when invoked without an argument) clear a previously
base address. See also ,,\fBa\fP''.
.IP "\fBbi\fP \fIaddr\fP"
Set an instruction breakpint at virtual
address \fIaddr\fP, or \fIbaseaddr\fP+\fIaddr\fP, if a base address has
previously been set.
.IP "\fBba\fP \fIsize\fP \fIaddr\fP"
Set an read or write access
breakpoint for access to the virtual address \fIaddr\fP (or \fIbaseaddr\fP+\fIaddr\fP, if a base address has previously been set) with
access width \fIsize\fP (must be one of 1, 2, 4).
.IP "\fBbw\fP \fIsize\fP \fIaddr\fP"
As ,,\fBba\fP'', but only for write
accesses.
.IP "\fBbt\fP [ \fIthreadid\fP ]"
Restrict a previously set breakpoint
to a particular thread, or (when not given an argument) remove such a
restriction.
.IP "\fBbx\fP \fIsize\fP \fIaddr\fP \fIlower_bound\fP \fIhigher_bound\fP"
Restrict
a previously set breakpoint. L4KD is
only entered if \fIaddr\fP contains a value of size \fIsize\fP that is
within the interval of [\fIlower_bound\fP, \fIhigher_bound\fP]. If \fIlower_bound\fP is greater then \fIhigher_bound\fP L4KD is only
entered if value is not within the interval (\fIhigher_bound\fP,\fIlower_bound\fP).
.IP "\fBt\fP [ \fIthreadid\fP | \fIlong_threadid\fP | \fItasknr\fP\fB.\fP\fIthreadnr\fP ]"
Show 
TCBs (thread control blocks), the state associated with threads. The
information displayed includes the thread's current kernel state,
register set, and kernel stack.
.IP
When given without an argument, display the current thread's TCB.
Otherwise display the given thread's TCB.
.IP
While displaying TCBs, the following additional commands are
available:
.RS
.IP "Cursor Up/Down/Left/Right"
Modify the displayed kernel stack pointer.
(This does not really modify the thread's stack pointer but is
intended for use with the next command.)
.IP "Return"
Recalculate the displayed register set (taken from the
kernel stack) based on a new kernel stack pointer adjusted with the
previous commands. L4KD assumes to find a \fBpusha\fP like sequence
plus an additional error code on the stack (the page fault handler
seems to be the only one that generates this sequence). This can be
used to evaluate the state of a thread that raised a page fault. Move
the stack pointer up until the error code (0xfe00000?) is gone and
press return.
.RE
.IP "\fBd\fP [ \fIaddr\fP ]"
Dump (display) memory at the current thread's
virtual address \fIaddr\fP (0 if none given). By default, the memory
is displayed in hexadecimal form using 4\-byte integers.
.IP
While dumping memory, the following additional commands are
available:
.RS
.IP "Cursor Up/Down/Left/Right"
Change cursor position.
.IP "PageUp/Down"
Scroll the display down/up one screen.
.IP "Space"
Change the displayed data format. This command cycles
between the following formats: 
.RS
.IP "\(bu"
hexadecimal display of 4\-byte integers (default when invoking ,,\fBd\fP''), 
.IP "\(bu"
hexadecimal display of bytes (1\-byte integers),
.IP "\(bu"
characters, 
.IP "\(bu"
x86 page table.
.RE
.IP "Return"
Interpret the 4\-byte integer the cursor is positioned at as
a pointer and start dumping memory at that address.
.IP "Home"
Return to the address of the pointer last dereferenced with
Return. (L4KD doesn't keep a history of all previous Returns, only
the last one.)
.RE
.IP "\fBp\fP [ \fItasknr\fP | \fIaddr\fP ]"
Dump x86 page table or page
directory for task \fItasknr\fP, or interpret memory at \fIaddr\fP as
a page table and dump it.
.IP
The same commands as with ,,\fBd\fP'' are available here, too, with two
modifications:
.RS
.IP "\(bu"
It's impossible to scroll out of a single page using the scrolling
commands.
.IP "\(bu"
The Home key can un\-dereference twice: back from a data page to a
page table, and back from a page table to a page directory.
.RE
.IP "\fBm\fP [ \fIframenr\fP ]"
Display mappings from the mapping
database for physical page frame \fIframenr\fP (i.e., for physical
address \fIframenr\fP*0x1000).
.IP
The mapping database represents mappings using a tree data
structure. The display's last three colums represent the links within
this tree. You can use the Cursor Down/Left/Right keys to traverse the
tree. You can follow a link as long as the last bit of the link is
zero. If you follow a link to the left/right with a least significant
bit set to one it will lead you back to the previous level. If you
follow such a link down, you will stay at the same point.
.IP "\fBv\fP \fIaddr\fP \fItasknr\fP"
Display the virtual\-to\-physical
address mapping for virtual address \fIaddr\fP in task \fItaskno\fP.
.IP "\fBk\fP"
Display global kernel state. This includes root pointers
for various thread queues, the system clock, and the page directory
pointer.
.IP "\fBi\fP \fIsize\fP \fIaddr\fP"
Input a value of width \fIsize\fP
from I/O address \fIaddr\fP and display it. \fIsize\fP must be one of
1, 2, 4.
.IP "\fBi\fP [ \fBa\fP | \fBi\fP ] \fIaddr\fP"
Input a value from the
APIC (,,\fBia\fP'') resp. the I/O APIC (,,\fBii\fP'') at address\fIaddr\fP and display it.
.IP "\fBo\fP [ \fIsize\fP | \fBa\fP | \fBi\fP ] \fIaddr\fP \fIvalue\fP"
Like
the corresponding form of ,,\fBi\fP'', but output the \fIvalue\fP given.
.IP "\fBH\fP"
Halt the current thread. (See the bugs section)
.IP "\fBT\fP [ \fB+\fP | \fB\-\fP ]"
Turn on and off single\-stepping.
.IP "\fBP\fP [ \fB+\fP | \fB*\fP | \fB\-\fP ]"
Monitor all page
faults in the system (,,\fBP+\fP'' and ,,\fBP*\fP''), or turn off
monitoring (,,\fBP\-\fP'').
.IP
,,\fBP+\fP'' stops the system upon each page fault and gives the user
the option of entering the kernel debugger (press ,,\fBi\fP'' when a
page fault message turns up) or simply resuming execution (any other
key).
.IP
,,\fBP*\fP'' just displays all page fault messages and doesn't offer
entering L4KD at page fault time.
.IP "\fBX\fP [ \fB+\fP \fIexcpnr\fP [ \fIerrcode_low\fP \fIerrcode_high\fP ] | \fB\-\fP ]"
Enter
L4KD upon catching an \fIexcpnr\fP exception with an error code
in the given range. (The error code range is only prompted for for
exceptions delivering error codes.)
.IP
,,\fBX\-\fP'' turns of exception monitoring.
.IP "\fBI\fP [ \fB+\fP | \fB\-\fP ]"
The command ,,\fBI+\fP'' starts
monitoring the keyboard (and a serial line, if initialized using ,,\fBVT\fP'') in the timer interrupt for a press of the Escape key. If
such an event occurs, L4KD is entered. Also, the timer interrupt will
output a progress indicator on the video console (not on a serial
terminal!) to make it easier to detect a hung system.
.IP
,,\fBI\-\fP'' disables this monitoring.
.IP "\fBV\fP [ \fBa\fP | \fBc\fP | \fBm\fP | \fBh\fP | \fBT\fP]"
Select 
a video mode for interaction with L4KD. ,,\fBVc\fP'' selects the CGA
output, and ,,\fBVh\fP'' or ,,\fBVm\fP'' select MGA (or Hercules)
output. ,,\fBVa\fP'' makes an atomatic choice between the first few
options (it uses the default video mode of the machine).
.IP
,,\fBVT\fP'' additionally enables output via a serial terminal
(attached to COM2; 115.2kBit/s, 8N1). Input from the terminal can
also be enabled by typing the character ,,\fB+\fP'' on the terminal.
Once this initialization has been completed, the terminal can also be
used to send Escape characters to enter L4KD (see ,,\fBI+\fP'').
.IP
Serial I/O and video console I/O can be used to control L4KD at the
same time: Any character typed on any of the input media will appear
on the other console device, too.
.SH "Bugs"
.SS "Serious Bugs"
The "\fBH\fP" command (halt kernel thread) currently doesn't work.
.PP
In all current versions of L4, all user tasks are privileged in the
sense that it is trivial for them to invoke L4KD, e.g. using the  enter_kdebug  interface.
.SS "Minor Bugs"
"\fBb\fP Space" doesn't show the current breakpoint (it displays
nothing)\(emuse "\fBb\fP Return".
.PP
(Pentium version only:) Due to machine limitations, instruction
pointer breakpoints in the virtual address space of tasks which have
been put into an L4 ``small address space'' have to be specified with
the instruction's linear address which is its virtual address plus the
small address space's segment's start address. Segments for small
address spaces start at linear address 0xC0000000.
.PP
When displaying on a serial terminal, the last (80th) column is not
displayed, and the display cannot be adjusted
to 24 instead of 25 lines. In practice, this seldom hurts.
.PP
When using a serial terminal, the PageUp/PageDown keys are reverted,
and the Home key is unavailable; also, there is no easy way to reboot
the machine (Shift\-Num doesn't work).
.PP
There is no way to browse the memory of a thread different from the
current one in a "\fBd\fP"\-like way. The only way to inspect memory
of a different task is to lookup single pages of memory through the
task's page directory using "\fBp\fP".
.PP
When browsing page directories using "\fBp\fP", dereferencing
pointers to super (4 MB) pages (by pressing Return) doesn't work
correctly.
.PP
There is no way to modify memory, even though there is a way to in/out
bytes through I/O memory ("\fBi\fP"/"\fBo\fP").
.PP
There is currently no direct way to circumvent the initial invocation
of L4KD during boot. However, this can be accomplished indirectly
using rmgr(8).
.PP
In this manual page, the description of the "\fBm\fP" command is too
terse.
.SH "See Also"
 l4kd_api ,  rmgr 
