_start = _binary_l4kernel_start + 0x1000;
ENTRY(_start)

SECTIONS
{
  /* Read-only sections, merged into text segment: */
  . = 0x0300000 + SIZEOF_HEADERS;

  _stext = .;

  .text      :
  {
    header.o(.data)                /* the header must come first! */
    *(.text)

    . = ALIGN(0x10);
    l4kernel.o(.data)              /* needs to be 16-byte-aligned */
  } =0x9090

  _etext = .;
  PROVIDE (etext = .);

  /* Adjust the address for the data segment.  We want to adjust up to
     the same address within the page on the next page up.  */
  . = ALIGN(0x1000) + ((ALIGN(8) + 0x1000 - ALIGN(0x1000)) & (0x1000 - 1));
  .data    :
  {
    *(.rodata)
    *(.data)
    CONSTRUCTORS
  }
  _edata  =  .;
  PROVIDE (edata = .);
  __bss_start = .;
  .bss       :
  {
   *(.bss)
   *(COMMON)
  }
  _end = . ;
  PROVIDE (end = .);
}
