.\"Warning: don't edit this file. It has been generated by typeset
.\" The next compilation will silently overwrite all changes.
.TH "l4_i386_ipc_send" 1 "16.07.96" "Institut" "User Commands"
.SH NAME
 l4_i386_ipc_send \- send a message to a thread

.SH " Synopsis"
.nf
\fB#include <ipc.h>\fP
.fi
.PP
\fBstatic inline int\fP 
.br
\fBl4_i386_ipc_send(l4_threadid_t\fP \fIdest\fP \fB, const void\fP
\fI*snd_msg\fP \fB, dword_t\fP \fIsnd_dword0\fP \fB, dword_t\fP
\fIsnd_dword1\fP \fBl4_timeout_t\fP \fItimeout\fP \fB,
l4_msgdope_t\fP \fI*result\fP \fB);\fP

.SH " Description"
\fIsnd_msg\fP is sent to the thread with id \fIdest\fP. There is no
receive phase included. The invoker continues working after sending
the message.
.SH " Arguments"
.IP "\fIdest\fP"
Thread id of the destination.
.IP "\fI*snd_msg\fP"
Pointer to a Send Descriptor. It can contain the 
following values:
.RS
.IP "<mem>"
Ipc includes sending a message to the destination 
specified by \fIdest\fP. \fI*snd_msg\fP must point to a valid
message. The first two 32\-bit words of the message have to be given 
separately in \fIsnd_dword0\fP and \fIsnd_dword1\fP.
.IP "\fB0\fP"
Ipc includes sending a message to the destination specified by\fIdest\fP. The message consists solely of the two 32\-bit words \fIsnd_dword0\fP and \fIsnd_dword1\fP. 
.RE
.IP "\fIsnd_dword0\fP"
The first dword to be transmitted.
.IP "\fIsnd_dword1\fP"
The second dword to be transmitted.
.IP "\fItimeout\fP"
This 32\-bit word specifies all 4 timouts, the
quadruple (snd, rcv, snd pf, rcv pf). For a detailed description see
the L4 Reference Manual.
.IP "\fIresult\fP"
The message dope describing the result of the Ipc.
.SH "Return Values"
The following return values are possible:
.IP "\fB0\fP"
No error occured. The optional send operation was
successful, and if a receive operation was also specified, a message
was also received correctly. 
.IP "\fBL4_IPC_ENOT_EXISTENT\fP"
Non\-existing destination or source.
.IP "\fBL4_IPC_RETIMEOUT\fP"
Timeout during receive operation.
.IP "\fBL4_IPC_SETIMEOUT\fP"
Timeout during send operation.
.IP "\fBL4_IPC_RECANCELED\fP"
Receive operation cancelled by another thread.
.IP "\fBL4_IPC_SECANCELED\fP"
Send operation cancelled by another thread.
.IP "\fBL4_IPC_REMAPFAILED\fP"
Map failed due to a shortage of page
tables during receive operation.
.IP "\fBL4_IPC_SEMAPFAILED\fP"
Map failed due to a shortage of page
tables during send operation.
.IP "\fBL4_IPC_RESNDPFTO\fP"
Send pagefault timeout.
.IP "\fBL4_IPC_SERCVPFTO\fP"
Receive pagefault timeout.
.IP "\fBL4_IPC_REABORTED\fP"
Receive operation aborted by another
thread.
.IP "\fBL4_IPC_SEABORTED\fP"
Send operation aborted by another thread.
.IP "\fBL4_IPC_REMSGCUT\fP"
Received message cut. Potential reasons
are:
.RS
.IP "(a)"
The recipient's mword buffer is too small.
.IP "(b)"
The recipient does not accept enough strings.
.IP "(c)"
At least one of the recipient's string buffers is too small.
.RE
.SH "See Also"
 l4_ipc ,  l4_i386_ipc_receive ,  l4_i386_ipc_reply_and_wait ,  l4_i386_ipc_reply_deceiting_and_wait ,  l4_i386_ipc_call ,  l4_i386_ipc_send_deceiting , l4_i386_ipc_wait  
