.\"Warning: don't edit this file. It has been generated by typeset
.\" The next compilation will silently overwrite all changes.
.TH "l4_i386_ipc_receive" 1 "16.07.96" "Institut" "User Commands"
.SH NAME
 l4_i386_ipc_receive \- wait for a message from a specified thread

.SH " Synopsis"
.nf
\fB#include <ipc.h>\fP
.fi
.PP
\fBstatic inline int\fP 
.br
\fBl4_i386_ipc_receive(l4_threadid_t\fP \fIsrc\fP \fB, void\fP
\fI*rcv_msg\fP \fB, dword_t\fP \fI*rcv_dword0\fP \fB, dword_t\fP
\fI*rcv_dword1\fP \fBl4_timeout_t\fP \fItimeout\fP \fB,
l4_msgdope_t\fP \fI*result\fP \fB);\fP

.SH " Description"
This operation includes no send phase. The invoker waits for a message
from \fIsrc\fP. Messages from other sources are not accepted. Note
that also a hardware interrupt might be specified as source.
.SH " Arguments"
.IP "\fIsrc\fP"
Thread id of the source.
.IP "\fI*rcv_msg\fP"
Pointer to Receive Descriptor. It can contain the
following values: 
.RS
.IP "\fB0\fP"
Only messages up to two 32\-bit words and are
accepted. The received message is returned in \fIrcv_dword0\fP and\fIrcv_dword1\fP. 
.IP "<mem>"
If Bit 1 of \fI*rcv_msg\fP is 0 ipc includes receiving a
message respectively waiting to receive a message. \fI*rcv_msg\fP must
point to a valid message. Note that the first two 32\-bit words of the 
received message are returned in \fIrcv_dword0\fP and \fIrcv_dword1\fP.
.IP "<rmap>"
If Bit 1 of \fI*rcv_msg\fP is 1 only send\-fpage
messages or up to two 32\-bit words (in \fIrcv_dword0\fP and\fIrcv_dword1\fP) are accepted. If a map message is received, the 30
most significant bits describe the receive fpage (instead of\fIrcvfpage option\fP in a memory message buffer). Thus fpages can
also be received without a message buffer in memory. 
.RE
.IP "\fI*rcv_dword0\fP"
First of two 32\-bit words of received message,
undefined if no message was received. 
.IP "\fI*rcv_dword1\fP"
Second of two 32\-bit words of received message,
undefined if no message was received. 
.IP "\fItimeout\fP"
This 32\-bit word specifies all 4 timouts, the
quadruple (snd, rcv, snd pf, rcv pf). For a detailed description see
the L4 Reference Manual.
.IP "\fIresult\fP"
The message dope describing the result of the Ipc.
.SH "Return Values"
The following return values are possible:
.IP "\fB0\fP"
No error occured. The optional send operation was
successful, and if a receive operation was also specified, a message
was also received correctly. 
.IP "\fBL4_IPC_ENOT_EXISTENT\fP"
Non\-existing destination or source.
.IP "\fBL4_IPC_RETIMEOUT\fP"
Timeout during receive operation.
.IP "\fBL4_IPC_SETIMEOUT\fP"
Timeout during send operation.
.IP "\fBL4_IPC_RECANCELED\fP"
Receive operation cancelled by another thread.
.IP "\fBL4_IPC_SECANCELED\fP"
Send operation cancelled by another thread.
.IP "\fBL4_IPC_REMAPFAILED\fP"
Map failed due to a shortage of page
tables during receive operation.
.IP "\fBL4_IPC_SEMAPFAILED\fP"
Map failed due to a shortage of page
tables during send operation.
.IP "\fBL4_IPC_RESNDPFTO\fP"
Send pagefault timeout.
.IP "\fBL4_IPC_SERCVPFTO\fP"
Receive pagefault timeout.
.IP "\fBL4_IPC_REABORTED\fP"
Receive operation aborted by another
thread.
.IP "\fBL4_IPC_SEABORTED\fP"
Send operation aborted by another thread.
.IP "\fBL4_IPC_REMSGCUT\fP"
Received message cut. Potential reasons
are:
.RS
.IP "(a)"
The recipient's mword buffer is too small.
.IP "(b)"
The recipient does not accept enough strings.
.IP "(c)"
At least one of the recipient's string buffers is too small.
.RE
.SH "See Also"
 l4_ipc ,  l4_i386_ipc_call ,  l4_i386_ipc_reply_and_wait ,  l4_i386_ipc_reply_deceiting_and_wait ,  l4_i386_ipc_send ,  l4_i386_ipc_send_deceiting , l4_i386_ipc_wait  
