/* scint.c	- Smartcard - "internal" functions
 *
 * Copyright 1993-1997, Tim Hudson. All rights reserved.
 *
 * You can pretty much do what you like with this code except pretend that 
 * you wrote it provided that any derivative of this code includes the
 * above comments unchanged. If you put this in a product then attribution
 * is mandatory. See the details in the COPYING file.
 *
 * Tim Hudson
 * tjh@cryptsoft.com
 *
 */

#include "platform.h"

#ifdef USE_STDIO
#include <stdio.h>
#endif /* USE_STDIO */

#include <ctype.h>
#include <stdlib.h>
#include <string.h>

#include "sio.h"
#include "sct0.h"
#include "sc.h"
#include "scint.h"
#include "strutil.h"

static int sc_sel(SC_STATE *sc,void *pinternalv,char *args,char *uout)
{
  char rspbuf[SC_MAX_HEX_DATA_LEN];
  char buf[BUFSIZ];
  char cmdbuf[32];
  char *p;

  /* skip leading whitespace */
  while (isspace(*args))
    args++;

  /* we have to have something in the way of parameters */
  if (strlen(args)==0)
    goto bad;

  /* convert a path using /'s into a series of SelectFile commands
   * from the MF to get to the desired file/dir 
   */
  strcpy(buf,args);

  /* if we have a full path (which is what would normally be the
   * case when we use this command) then we select the MF to
   * start with
   */
  if (args[0]=='/') {
    if (sc->slog)
      SLOG_printf(sc->slog,"sc_sel 3F00\n",p);
    if (!SC_ExecuteCommand(sc,"SelectFile 3F00",rspbuf,1))
      goto bad;
    if (sc->last_rsp.rsp_code!=SC_RSP_OK)
      goto bad;
  }

  p=mstrtok(buf,"/");
  while (p!=NULL) {
    if (sc->slog)
      SLOG_printf(sc->slog,"sc_sel \"%s\"\n",p);

    if (strlen(p)>0) {
      sprintf(cmdbuf,"SelectFile %s",p);
      if (!SC_ExecuteCommand(sc,cmdbuf,rspbuf,1))
	goto bad;
      if (sc->last_rsp.rsp_code!=SC_RSP_OK)
	goto bad;
    }
    p=mstrtok(buf,"/");
  }
  mstrtok_clear(buf);
done: ;
  sprintf(uout,"OK");
  return(1);
bad: ;
  mstrtok_clear(buf);
  SC_ClearVars(sc);
  if (sc->slog)
    SLOG_printf(sc->slog,"sc_sel %s failed\n",args);
  sprintf(uout,"FAILED");
  return (0);
}

static int sc_dir(SC_STATE *sc,void *pinternalv,char *args,char *uout)
{
  char rspbuf[SC_MAX_HEX_DATA_LEN];
  char buf[BUFSIZ];
  char *p;
  int count,i;

  uout[0]='\0';
  if (sc->slog)
    SLOG_printf(sc->slog,"sc_dir start\n");

  /* we select whatever the arg is so we can take a dir of
   * something from anywhere
   */
  if (!sc_sel(sc,pinternalv,args,uout))
    goto bad;

  if (!SC_ExecuteCommand(sc,"ReadDirectory",rspbuf,1)) {
    /* if the card doesn't have a readdirectory command then
     * we need to indicate this clearly
     */
    if (sc->error_code==SC_ERR_EXE_CMD_NOT_FOUND)
      sc->error_code=SC_ERR_NOT_SUPPORTED;
    goto bad;
  }

  if (sc->slog)
    SLOG_printf(sc->slog,"sc_dir loop\n");

  /* now loop over each directory entry and just dump the file names */
  p=SC_GetVar(sc,"$COUNT");
  if (p==NULL) {
    if (sc->slog) {
      SLOG_printf(sc->slog,"sc_dir NO COUNT\n");
    }
    goto bad;
  }
  count=strtoul(p,NULL,10);

  if (sc->slog)
    SLOG_printf(sc->slog,"sc_dir count=%d\n",count);

  for(i=0;i<count;i++) {
    /* first we basically want a space separated file list 
     * returned as part of the command 
     */
    sprintf(buf,"FILE_ID[%d]",i);
    p=SC_GetVar(sc,buf);
    if (p!=NULL) {
      strcat(uout,p);
      strcat(uout," ");
    }

    /* do something */
    sprintf(buf,"!echo ID=${FILE_ID[%d]} SIZE=${FILE_SIZE[%d]} TYPE=${FILE_TYPE[%d]}",
                        i,i,i);
    if (sc->slog)
      SLOG_printf(sc->slog,"sc_dir cmd=%s\n",buf);
    SC_ExecuteCommand(sc,buf,rspbuf,0);
  }

  /* blow away vars */
  SC_ClearVars(sc);
  rspbuf[0]='\0';

  return(1);

bad: ;
  if (sc->slog)
    SLOG_printf(sc->slog,"sc_dir %s failed\n",args);

  sprintf(uout,"FAILED");
  return(0);
}

SC_CMD_INTERNAL sc_icmds[]={
{ "sc_dir", NULL, sc_dir },
{ "sc_sel", NULL, sc_sel }
};
#define _N_sc_icmds (sizeof(sc_icmds)/sizeof(sc_icmds[0]))
int N_sc_icmds=_N_sc_icmds;

