/* stest.c	- serial I/O handler - test program
 *
 * Copyright 1993-1997, Tim Hudson. All rights reserved.
 *
 * You can pretty much do what you like with this code except pretend that 
 * you wrote it provided that any derivative of this code includes the
 * above comments unchanged. If you put this in a product then attribution
 * is mandatory. See the details in the COPYING file.
 *
 * 12-Oct-97 tjh        added in new slog stuff and ATR display
 * 30-Aug-97 tjh	reworked into this form
 *
 * Tim Hudson
 * tjh@cryptsoft.com
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "platform.h"

#ifdef unix
#include <unistd.h>
#endif

#ifdef WINDOWS
#include <io.h>
#endif

#include "sio.h"
#include "sct0.h"
#include "sc.h"

#include "options.h"

/* setup defaults that match my testing environments to save
 * me a small amount of time when moving the code about
 * - basically the second serial port on each of the systems 
 *   is what I use by default
 */
#ifdef DEFAULT_DEVICE
char *device=DEFAULT_DEVICE;
#else /* !DEFAULT_DEVICE */
#ifdef WINDOWS
char *device="com2:";
#endif
#ifdef SUNOS5
char *device="/dev/ttyb";
#endif
#ifdef LINUX
char *device="/dev/ttyS1";
#endif
#endif /* DEFAULT_DEVICE */

/* scam emulation */
extern int do_scam(SIO_INFO *s,FILE *inf,FILE *outf);

static int dbglev=0;

static int exit_ret=0;

int main(argc,argv)
int argc;
char *argv[];
{
  SIO_INFO *s;
  SLOG *slog;
  char buf[BUFSIZ];
  char data[BUFSIZ];
  char scanres[256];
  int ch;
  int i,len,datalen;
  unsigned char achar;
  char *comparams;
  int no_scam_mode,atr_mode,scam_mode,filter_echo,do_help;
  FILE *inf,*outf;
  char *emulate;
  char *logfile;
  char *thetimeout;
  char *p;
  int l;

  slog=NULL;
  s=NULL;
  thetimeout=logfile=emulate=comparams=NULL;
  dbglev=0;
  atr_mode=do_help=filter_echo=no_scam_mode=0;
  scam_mode=1;

  OPTIONS("[-c comdevice] [-e emulate] [-p comparams] [-d dbglev] [-s infile outfile] [-x]")
    STRING('c',device)
    STRING('p',comparams)
    STRING('e',emulate)
    STRING('l',logfile)
    STRING('t',thetimeout)
    NUMBER('d',dbglev)
    FLAG('s',scam_mode)
    FLAG('S',no_scam_mode)
    FLAG('x',filter_echo)
    FLAG('A',atr_mode)
    FLAG('?',do_help)
    FLAG('h',do_help)
  ENDOPTS

  /* I've changed the defaults around a little so you
   * have to try hard to get into non-scam mode now
   */
  if (no_scam_mode)
    scam_mode=0;

  if (do_help) {
    /* one day I'll finish this bit off */
    fprintf(stderr,"Not yet implemented\n");
    goto exit_time;
  }

  /* propagate debug settings into the "libraries" */
  slog=SLOG_open("-",1);
  SCT0_SetDebug(dbglev);
  SCT0_SetDebugLog(slog);
  if (dbglev>1) {
    SIO_SetDebug(dbglev);
    SIO_SetDebugLog(slog);
  }

  if (atr_mode) {
    fprintf(stderr,"# STEST: ATR parsing mode\n");
    fflush(stderr);
    while(fgets(buf,sizeof(buf),stdin)!=NULL) {
      /* allow comments to be ignored */
      if (buf[0]=='#') {
	printf("%s",buf);
	continue;
      }
      datalen=0;
      p=strtok(buf," \t\n");
      while (p!=NULL) {
	data[datalen++]=(unsigned char)(strtoul(p,NULL,16) & 0xff);
	p=strtok(NULL," \t\n");
      }
      SC_DumpATR(stdout,data,datalen,0);
    }
    goto exit_time;
  }

  /* the usual execution path is to run in SCAM mode ... the other
   * logic in here is less general purpose
   */
  if (scam_mode) {
    /* process two optional args */
    /*
    if (argc<2) {
      fprintf(stderr,"scam mode requires two args - infile and outfile\n");
      fflush(stderr);
      exit_ret=1;
      goto exit_time;
    }
    */

    if (argc==1) {
      /* no additional args is okay ... we take that to mean we want
       * to work interactively with stdin/stdout
       */
      inf=stdin;
      outf=stdout;
    } else {
      if (strcmp(argv[1],"-")==0)
	inf=stdin;
      else
	inf=fopen(argv[1],"r");
      if (strcmp(argv[2],"-")==0)
	outf=stdout;
      else
	outf=fopen(argv[2],"w");
    }

    if (inf==NULL) {
      fprintf(stderr,"unable to open %s for input\n",argv[1]);
      exit_ret=1;
      goto exit_time;
    }
    if (outf==NULL) {
      fprintf(stderr,"unable to open %s for output\n",argv[2]);
      exit_ret=1;
      goto exit_time;
    }

    s=SIO_Open(device);
    if (s!=NULL) {
      if (logfile!=NULL)
        SIO_SetLogFile(s,logfile);
      SIO_FilterEcho(s,filter_echo);

      /* set the standard scam communication defaults */
      if (comparams!=NULL)
	SIO_SetSettingsString(s,comparams);
      else
        SIO_SetSettingsString(s,"9600 8 2 O I");

      if (thetimeout!=NULL) {
	l=strtoul(thetimeout,NULL,0);
	SIO_SetReadTimeout(s,l);
      }

      /* now invoke the scam emulation logic */
      do_scam(s,inf,outf);

      SIO_Close(s);
      goto exit_time;
      
    } else {
      fprintf(stderr,"Failed to open %s\n",device);
      exit_ret=1;
      goto exit_time;
    }
  }

  /* if we are called with an arg we take this to mean scan for the
   * right comms settings and the do an instruction scan and dump the
   * results ... which is a good start for a new card
   */
  if (argc>1) {
    fprintf(stderr,"# STEST: comms scanning mode\n");
    fflush(stderr);
    s=SIO_Open(device);
    if (s!=NULL) {
      if (logfile!=NULL)
        SIO_SetLogFile(s,logfile);
      SIO_FilterEcho(s,filter_echo);
      if (comparams!=NULL)
	SIO_SetSettingsString(s,comparams);
      len=SCT0_ScanForATR(s,buf,sizeof(buf));
      if (len>0) {
	if (SCT0_ScanClasses(s,scanres)!=-1) {
	  fprintf(stderr,"SCAN: %s\n",scanres);
	  for(i=0;i<256;i++) {
	    if (scanres[i]==1)
	      fprintf(stderr,"%02x ",i);
	  }
	  fprintf(stderr,"\n");
	}
      }
      SIO_Close(s);
    } else {
      fprintf(stderr,"Failed to open %s\n",device);
    }
    goto exit_time;
  }

  /* when running with no command and not in scam mode we do
   * a mini interactive setup where we are basically reading
   * in the
   */
  fprintf(stderr,"# STEST: sio test mode\n");
  fflush(stderr);
  s=SIO_Open(device);
  if (s!=NULL) {
    if (logfile!=NULL)
      SIO_SetLogFile(s,logfile);
    SIO_FilterEcho(s,filter_echo);
    if (comparams!=NULL)
      SIO_SetSettingsString(s,comparams);
    fprintf(stderr,"Opened %s\n",device);
    fprintf(stderr,"speed=%ld\n",SIO_GetSpeed(s));
    fprintf(stderr,"databits=%d\n",SIO_GetDataBits(s));
    fprintf(stderr,"stopbits=%d\n",SIO_GetStopBits(s));
    fprintf(stderr,"parity=%s\n",SIO_Parity2String(SIO_GetParity(s)));
    fprintf(stderr,"Settings=%s\n",SIO_GetSettingsString(s));

#if 0
    /* change the baud rate and see if it sticks */
    SIO_SetSpeed(s,4800);
    SIO_WriteSettings(s);
    SIO_ReadSettings(s);
    fprintf(stderr,"speed=%d\n",SIO_GetSpeed(s));
#endif

#if 0
    SIO_ReadControlState(s);
    fprintf(stderr,"control_state=%s\n",SIO_ControlState2String(s));

    SIO_SetControlState(s,SIO_CONTROL_RTS,0);
    SIO_WriteControlState(s);

    SIO_ReadControlState(s);
    fprintf(stderr,"control_state=%s (RTS should be low)\n",SIO_ControlState2String(s));

    SIO_SetControlState(s,SIO_CONTROL_RTS,1);
    SIO_WriteControlState(s);

    SIO_ReadControlState(s);
    fprintf(stderr,"control_state=%s (RTS should be high)\n",SIO_ControlState2String(s));

    gets(buf);
#endif

#if 0
    /* setup for gemplus */
    /*
    Baud 9600; DBits 8; SBits 1; Parity n; Conv i;
    */
    SIO_SetSpeed(s,9600);
    SIO_SetDataBits(s,8);
    SIO_SetStopBits(s,2);
    SIO_SetParity(s,SIO_PARITY_EVEN);
    SIO_SetIOMode(s,SIO_IOMODE_INDIRECT);
    SIO_WriteSettings(s);
#endif

#if 0
    /* standard serial mouse settings ... */
    SIO_SetSpeed(s,2400);
    SIO_SetSpeed(s,9600);
    SIO_SetDataBits(s,8);
    SIO_SetStopBits(s,1);
    SIO_SetParity(s,SIO_PARITY_NONE);
    SIO_SetIOMode(s,SIO_IOMODE_DIRECT);
    SIO_WriteSettings(s);
#endif

#if 0
    /* lower and then raise RTS to reset the card */
    SIO_DropRTS(s);
    SIO_RaiseRTS(s);
#endif
    fprintf(stderr,"Settings=%s\n",SIO_GetSettingsString(s));

    /*
    SIO_SetReadTimeout(s,SIO_READ_WAIT_FOREVER);
    */

    /* ignore the following logic for the moment ... I'm playing around
     * with emulation of various smartcard readers to see what it will
     * take to convince software that is hardwired to specific readers to
     * work with a dumbmouse sitting behind some software that pretends 
     * to be the reader - this wouldn't be an issue if it wasn't for the
     * total lack of standardisation of the host<->reader comms
     */
    if (emulate!=NULL) {
      while(1) {
	int l,r;

	l=0;
	while ((ch=SIO_ReadChar(s))!=-1) {
	  achar=(unsigned char)(ch & 0xff);
	  buf[l++]=achar;
	}

	if (l>0) {
	  /* if (l=SIO_ReadBuffer(s,buf,sizeof(buf))>0) */
	  SIO_DumpBuffer(stderr,buf,l,2);
	  fprintf(stderr,"\n");
	  fflush(stderr);

	  /* Schlumberger reader ... */
	  if (strcmp(emulate,"SCT")==0) {
	    if ((l==5) && (buf[0]==0x02)) {
	      if ((buf[1]=='S')&&(buf[2]=='T')&&
		    (buf[3]==0x03)&&(buf[4]==0x07)) {
		fprintf(stderr,"Sending back response to initial command\n");
		fflush(stderr);
		l=0;
		buf[l++]=0x02;
		buf[l++]=0x30;
		buf[l++]=0x32;
		buf[l++]=0x33;
		buf[l++]=0x30;
		buf[l++]=0x30;
		buf[l++]=0x30;
		buf[l++]=0x03;
		buf[l++]=0x01;
		r=SIO_WriteBuffer(s,buf,l);
		fprintf(stderr,"WROTE %d\n",r);
		/*
		SIO_WriteChar(s,0x02);
		SIO_WriteChar(s,0x30);
		SIO_WriteChar(s,0x30);
		SIO_WriteChar(s,0x30);
		SIO_WriteChar(s,0x31);
		SIO_WriteChar(s,0x30);
		SIO_WriteChar(s,0x30);
		SIO_WriteChar(s,0x03);
		SIO_WriteChar(s,0x01);
		*/
	      }
	    }
	    if ((l==10) && (buf[0]==0x02)) {
	      if ((buf[1]==0x53)&&(buf[2]==0x48)) {
		fprintf(stderr,"Sending back response to card insertion\n");
		fflush(stderr);
		l=0;
		buf[l++]=0x01;
		buf[l++]=0x02;
		buf[l++]=0x30;
		buf[l++]=0x30;
		buf[l++]=0x30;
		buf[l++]=0x31;
		buf[l++]=0x30;
		buf[l++]=0x30;
		buf[l++]=0x03;
		r=0;
		for(i=0;i<l;i++) {
		  r+=SIO_WriteChar(s,buf[l] & 0xff);
		}
		/*
		r=SIO_WriteBuffer(s,buf,l);
		*/
		fprintf(stderr,"WROTE %d\n",r);
	      }
	    }
	  }
	}
      }
    }

    /* now read in some data - forever ... not much of an interface
     * but useful for testing what data is sent under various external
     * influences and also for testing to see if we drop data that is
     * injected at high speed
     */
    while(1) {
      len=0;
      /* try to gather bytes together */
      for(i=0;i<2;i++) {
	while ((ch=SIO_ReadChar(s))!=-1) {
	  achar=(unsigned char)(ch & 0xff);
	  buf[len++]=achar;
	}
      }
      if (len>0) {
	SIO_DumpBuffer(stderr,buf,len,0);
	fprintf(stderr,"\n");
	SIO_DumpBuffer(stderr,buf,len,1);
	fprintf(stderr,"\n");
      }
    }
    fprintf(stderr,"\n");

    SIO_Close(s);
  } else {
    fprintf(stderr,"Failed to open %s\n",device);
  }

exit_time: ;
  if (slog!=NULL)
    SLOG_close(slog);

  return(exit_ret);
}

