/* sct0.h	- Smartcard T=0 related functions
 *
 * Copyright 1993-1997, Tim Hudson. All rights reserved.
 *
 * You can pretty much do what you like with this code except pretend that 
 * you wrote it provided that any derivative of this code includes the
 * above comments unchanged. If you put this in a product then attribution
 * is mandatory. See the details in the COPYING file.
 *
 * Tim Hudson
 * tjh@cryptsoft.com
 *
 */

#ifndef HEADER_SCT0_H
#define HEADER_SCT0_H

#include "platform.h"
#include "slog.h"

int SCT0_SetDebug(int lev);
int SCT0_SetDebugLog(SLOG *slog);
int SCT0_GetDebug(void);

/* reset the smartcard - should respond with ATR */
int SCT0_Reset(SIO_INFO *s);

/* get a buffer of data */
int SCT0_GetATR(SIO_INFO *s,char *buf,int bufsize);

/* request ATR from smartcard (calls reset) */
int SCT0_GetATR(SIO_INFO *s,char *buf,int bufsize);

/* try all communication settings until a valid ATR */
int SCT0_ScanForATR(SIO_INFO *s,char *buf, int bufsize);

/* pass in an array of 256 chars which will be set to the 
 * result code from a class scan
 */
int SCT0_ScanClasses(SIO_INFO *s,char *classlist);

/* pass in an array of 256 chars which will be set to the 
 * result code from an instruction scan for a given class
 */
int SCT0_ScanInstructions(SIO_INFO *s,char theclass,char *inslist);

/* pass in an array of 256 chars which will be set to the 
 * result code from a scan of files using the given class prefix
 * and the specified first byte of the fileid
 */
int SCT0_ScanFiles(SIO_INFO *s,char theclass,char thefile,char *filelist);

#endif /* HEADER_SCT0_H */

