#include "getresponse.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#define private private_hack
extern "C" {
#include <sio.h>
#include <sct0.h>
#include <sc.h>
}
#undef private

int timeout;

SIO_INFO* si;
Byte selectfile[] = { 0xa0, 0xa4, 0x00, 0x00, 0x02 };
Byte gsm_file[] = { 0x7f, 0x20 };
Byte gsm2_file[] = { 0x7f, 0x21 };
Byte get_res[] = { 0xa0, 0xc0, 0x00,  0x00, 0x00 };
Byte verify_pin[] = { 0xa0, 0x20, 0x00, 0x01, 0x08 };
Byte generate_sres[] = { 0xa0, 0x88, 0x00, 0x00, 0x10 };

void init_card(char* devicename, Byte pin[8]) {
  Byte buffer[32];
  int i;
  SC_ATR * atr;
  SC_STATE *sc;
  SLOG *log;

  si = SIO_Open(devicename);
  if (si!=NULL) {
    /* setup for 9600, 8 data, 2 stop, even parity */
    SIO_SetSpeed(si,9600);
    SIO_SetDataBits(si,8);
    SIO_SetStopBits(si,2);
    SIO_SetParity(si,SIO_PARITY_ODD);
    SIO_SetIOMode(si,SIO_IOMODE_INDIRECT);
    SIO_FilterEcho(si, 1);

    /* now actually change the line settings */
    SIO_WriteSettings(si);

    /* trigger ATR from a Smartcard */
    if(i = SCT0_GetATR(si, buffer, 32)) {
      atr=SC_DecodeATR(buffer, i);
      printf("ATR: %s\n", SC_ATR2Text(atr, 0));
      
      SIO_Delay(si,10000);
      SIO_WriteBuffer(si, selectfile, 5);
      SIO_WaitForData(si, 1000);
      SIO_ReadBuffer(si, buffer, 32);

      SIO_WriteBuffer(si, gsm_file, 2);
      SIO_WaitForData(si, 1000);
      SIO_ReadBuffer(si, buffer, 32);

      if(buffer[0] != 0x9f) {
	printf("selecting gsm_file failed, trying DCS1800!\n");

	SIO_WriteBuffer(si, selectfile, 5);
	SIO_WaitForData(si, 1000);
	SIO_ReadBuffer(si, buffer, 32);

	SIO_WriteBuffer(si, gsm2_file, 2);
	SIO_WaitForData(si, 1000);
	SIO_ReadBuffer(si, buffer, 32);

	if(buffer[0] != 0x9f) {
	  printf("selecting gsm_file failed!\n");
	  exit(1);
	}
      }
      get_res[4] = buffer[1];
      memcpy(buffer, get_res, 5);
      SIO_WriteBuffer(si, buffer, 5);
      SIO_WaitForData(si, 1000);
      i = SIO_ReadBuffer(si, buffer, 32);

      SIO_WriteBuffer(si, verify_pin, 5);
      SIO_WaitForData(si, 1000);
      i = SIO_ReadBuffer(si, buffer, 32);

      SIO_WriteBuffer(si, pin, 8);
      SIO_Delay(si,100000);
      SIO_WaitForData(si, 1000);
      i = SIO_ReadBuffer(si, buffer, 32);

      if(buffer[0] != 0x90) {
	printf("PIN verification failed!\n");
	for(int j=0; j<i; j++) {
	  printf("0x%02X ", buffer[j]);
	}
	printf("\n");
	exit(1);
      }

    } else {
      printf("Sorry, connection to your smart card failed.\n");
      exit(1);
    }
  } else {
    printf("Sorry, opening the device %s failed.\n", devicename);
    exit(1);
  }
}


void get_response(Byte challenge[16], Byte response[12]) {
  Byte buffer[32];
  int i;

  memcpy(buffer, generate_sres, 5);
  SIO_WriteBuffer(si, buffer, 5);
  do {
    SIO_WaitForData(si, 1000);
    i = SIO_ReadBuffer(si, buffer, 32);
  } while (i==0);


  memcpy(buffer, challenge, 16);
  SIO_WriteBuffer(si, buffer, 16);
  SIO_Delay(si, timeout);
  do {
    SIO_WaitForData(si, 1000);
    i = SIO_ReadBuffer(si, buffer, 32);
  } while (i==0);

  if(buffer[0] != 0x9f) {
    printf("getting response failed!\n");
    exit(1);
  }

  get_res[4] = buffer[1];
  memcpy(buffer, get_res, 5);
  SIO_WriteBuffer(si, buffer, 5);
  SIO_WaitForData(si, 1000);
  i = SIO_ReadBuffer(si, buffer, 32);

  memcpy(response, buffer + 1, 12);
}

void set_timeout(int t) {
  timeout = t;
}

#ifdef 0
int main(int argc, char** argv) {
  Byte challenge[16] = { 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
  Byte pin[8] = { 0x35, 0x35, 0x35, 0x35, 0xff, 0xff, 0xff, 0xff };

  Byte response[12];

  init_card("/dev/ttyS1", pin);
  get_response(challenge, response);
}
#endif
