#!/usr/local/bin/perl

use Tie::DB_Lock;

my $scoresDBFile = "data/scores.db";

my %scores;
tie %scores, 'Tie::DB_Lock', $scoresDBFile, 'r'
    or die "$0: could not die to scores DB $scoresDBFile: $!\n";

my $cumul;
my $prev;

foreach (sort keys %scores) {
#    print "$_: $scores{$_}\n";
    next if (/^__/);
    my $key = $_;
    s/.dm.berlin.ccc.de:.*//;
    if ($prev ne $_) {
	print "$prev: $cumul\n" unless (not defined $prev);
	$prev = $_;
	$cumul = $scores{$key};
    } else {
	$cumul += $scores{$key};
    }
}

print "$prev: $cumul\n" unless (not defined $prev);
