#!/usr/local/bin/perl 

use Chart::StackedBars;
use POSIX qw(strftime);
use Tie::DB_Lock;

my $scoresDBFile = '/home/hans/deathmatch/data/scores.db';

my %scores;
tie %scores, 'Tie::DB_Lock', $scoresDBFile, 'r'
    or die "$0: could not tie to scores DB $scoresDBFile: $!\n";

my @clients = sort split(/:/, $scores{'__allClientNames__'});
my @probes = sort split(/:/, $scores{'__allProbeNames__'});


$g = Chart::StackedBars->new(600, 400); 
$g->add_dataset (@clients);
my $probe;
foreach $probe (@probes) {
    my @row;
    foreach (@clients) {
	push @row, $scores{"$_:$probe"};
    }
    $g->add_dataset(@row);
}

$g->set ('x_label' => 'Team');
$g->set ('y_label' => 'Punkte');
#$g->set ('transparent' => 'true');
$g->set ('title' => 'Aktueller Punktestand');
$g->set ('sub_title' => strftime("Uhrzeit: %H:%M:%S", localtime time));
$g->set ('legend_labels' => \@probes);
$| = 1;
#print "Refresh: 30;\n";
#print "Content-type: image/gif\n\n";
#$g->gif ('/dev/fd/1');
$g->gif ('bla.gif');

exit (0);
