#!/usr/local/bin/perl

# INSTALL-MODULES.pl	Try to install all modules used by found in the current 
#			directory 

use CPAN;
use File::Find;
use Getopt::Std;

$hiddenModules = "00-extra-modules.pl";

my %opts;
&getopts("v", \%opts);
my $verbose = $opts{v};

my %checked;

sub checkUse {

    if (not $_) {
	$_ = shift;
	$name = shift;
    } else {
	$name = $File::Find::name;
    }
	
    if (/^.*\.(pl|pm)$/) {
	open(SCRIPT, $_)
	    or warn "$0: can't open $name: $!\n";
	print STDERR "$0: checking $name:" if ($verbose);
	while (<SCRIPT>) {
	    chomp;
	    s/#.*//;
	    if (/^\s*use\s+([^;\s]+)/) {
		my $module = $1;
		next if ($checked{$module});
		print STDERR " $module" if ($verbose);
		$checked{$module} = 1;
		if (not eval "use $module; 1;") {
		    my $name = $name;
		    print STDERR "$0: installing: $module (used by $name)\n";
		    my $dir = $File::Find::dir;
		  CPAN::Shell->install($module);
		    chdir($dir) or die "$0: can't chdir to $dir.  try again\n";
		    if (not eval "use $module; 1;") {
			warn "$0: could not find module $module in CPAN\n\tused by $name\n";
			push(@notFound, $module);
		    }
		}
	    }
	}
	close(SCRIPT);
	print STDERR "\n" if ($verbose);
    }
}

if (-f $hiddenModules) {
    checkUse($hiddenModules, $hiddenModules);
}

find(\&checkUse, '.');

if (@notFound) {
    warn "$0: could not install module(s) ", join(", ", @notFound), "\n";
} else {
    warn "$0: all module references found are correctly installed\n";
}
							  p
