
#@# timeout: 8
#@# interval: 60

use Net::POP3;
use strict;
use DB_File;

my $arg = shift;

my ($addr, $user, $password);

if (ref($arg)) {
    $addr = $arg->{'addr'};
    $user = $arg->{'user'};
    $password = $arg->{'password'};
} else {
    $addr = $arg;
    $user = shift;
    $password = shift;
}

my %seenMessages;	# messages seen by the pop3 client
tie %seenMessages, 'DB_File', 'pop3-seen.db', O_RDWR | O_CREAT, 0644, $DB_HASH
    or die "pop3: can't open/create db file pop3-seen.db: $!\n";
my %sentMessages;	# messages sent by the smtp server (indexed by msgid)
tie %sentMessages, 'DB_File', 'smtp-sent.db', O_RDWR | O_CREAT, 0644, $DB_HASH
    or die "pop3: can't open/create db file smtp-sent.db: $!\n";

my $pop = new Net::POP3($addr, Debug => 1);

die "pop3: can't connect to pop server on $addr ($!)\n"
    if (not defined $pop);

my $count = $pop->login($user, $password);

die "pop3: failed to login\n"
    if (not defined $count);

my $uidl = $pop->uidl();

my $messageNo;
foreach $messageNo (keys %$uidl) {
    if (not defined $seenMessages{$uidl->{$messageNo}}) {
	my $header = $pop->top($messageNo, 0)
	    or die "pop3: failed to get message header $messageNo: "
		. $pop->message;
	my ($subject, $messageID);
	foreach (@$header) {
	    if (/^Message-ID: (\S+)/i) {
		$messageID = $1;
	    } elsif (/^Subject: (.*)\n/i) {
		$subject = $1;
	    }
	}
	print STDERR "pop3: got message $messageID ($subject): ";
	if (defined $sentMessages{$messageID}
	    and $sentMessages{$messageID} eq 'open') {

	    $sentMessages{$messageID} = 'closed';
	    if ($subject =~ /^(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})$/) {
		print "$1 300\n";
		print STDERR "pop3: counted for ip $1\n";
	    } else {
		print STDERR "pop3: bad subject [$subject], message ignored\n";
	    }
	} else {
	    print STDERR "pop3: unknown Message-ID - ignored\n";
	}
	$seenMessages{$uidl->{$messageNo}} = 1;
    }
}
