#!/usr/local/bin/perl

use DB_File;
use Fcntl;
use Socket;
use strict;

my $dbFilename = 'data/net-traffic.db';
my $myNet = "192.168.111";
my $interface = "de0";

my $stop = 0;

$SIG{QUIT} = sub {

    $stop = 1;
};

my %log;
tie %log, 'DB_File', $dbFilename, O_RDWR | O_CREAT, 0600, $DB_HASH
    or die "$0: can't tie DB file $dbFilename: $!\n";

sub dumpStatistics {
    $SIG{INT} = \&dumpStatistics;

    foreach (keys %log) {
	my $hostname
	    = gethostbyaddr(inet_aton($_), AF_INET)
		or $_;
	print "$hostname: $log{$_}\n";
    }
    print "\n";
}

$SIG{INT} = 'IGNORE';

open(TCPDUMP, "sudo tcpdump -lne -i $interface 'ip and not ( src net $myNet and dst net $myNet )'|")
    or die "$0: can't popen tcpdump: $!\n";

$SIG{INT} = \&dumpStatistics;

while (not $stop) {

    last if (eof(TCPDUMP));

    $_ = <TCPDUMP>;
    my $line = $_;
    s/://g;
    my ($time, $srcEther, $destEther, $proto, $length, $srcIP, $junk, $destIP, $more)
	= split;
    my $chargeTo = $srcIP;
    if ($srcIP !~ /^$myNet/) {
	$chargeTo = $destIP;
    }
    if ($chargeTo !~ /^(\d+\.\d+\.\d+\.\d+)\.\d+$/) {
	print "unparseable: $line\n";
	next;
    }
    $chargeTo = $1;
    if (not defined $log{$chargeTo}) {
	$log{$chargeTo} = 0;
    }
    $log{$chargeTo} += $length;
    print STDERR ".";
}
close(TCPDUMP);

