#!/usr/local/bin/perl -w

# Simple PriorityQueue implementation.  Elements are enqueued with a
# priority, and are dequeued with lowest priority elements first.
# dequeue and front return a hash reference with two elements.  The
# element named 'priority' designates the priority of the item, the
# 'item' represents whatever has been enqueued.

package PriorityQueue;
use strict;

sub new {
    my $class = shift;

    my $self = [];
    bless $self, $class;

    return $self;
}

sub enqueue {
    my $self = shift;
    my $priority = shift;
    my $item = shift;

    my $entry = { priority => $priority,
		  item => $item };

    if ($#$self == -1) {

	$self->[0] = $entry;

    } else {

	my $insertAt = 0;

	for (;$insertAt <= $#$self; $insertAt++) {
	    last if ($self->[$insertAt]->{'priority'} > $priority);
	}

	splice(@$self, $insertAt, 0, $entry);
    }
}

sub dequeue {
    my $self = shift;

    if (@$self) {
	return shift @$self;
    } else {
	return undef;
    }
}

sub front {
    my $self = shift;

    if (@$self) {
	return $self->[0];
    } else {
	return undef;
    }
}

1;
