/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.argument.keywords.ConcatDictToStorageNode;
import com.oracle.graal.python.nodes.argument.keywords.NonMappingException;
import com.oracle.graal.python.nodes.argument.keywords.SameDictKeyException;
import com.oracle.graal.python.nodes.bytecode.AbstractKwargsNode;
import com.oracle.graal.python.nodes.bytecode.KwargsMergeNodeGen;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;

@GenerateUncached
@GenerateInline(value=false)
public abstract class KwargsMergeNode
extends AbstractKwargsNode {
    public abstract int execute(Frame var1, int var2);

    @Specialization
    static int merge(VirtualFrame frame, int initialStackTop, @Bind Node inliningTarget, @Cached ConcatDictToStorageNode concatNode, @Cached PRaiseNode raise, @Cached InlinedBranchProfile keywordsError1, @Cached InlinedBranchProfile keywordsError2) {
        int stackTop = initialStackTop;
        Object mapping = frame.getObject(stackTop);
        frame.setObject(stackTop--, null);
        PDict dict = (PDict)frame.getObject(stackTop);
        try {
            HashingStorage resultStorage = concatNode.execute(frame, dict.getDictStorage(), mapping);
            dict.setDictStorage(resultStorage);
        }
        catch (SameDictKeyException e) {
            keywordsError1.enter(inliningTarget);
            throw KwargsMergeNode.handleSameKey(frame, inliningTarget, raise, stackTop, e);
        }
        catch (NonMappingException e) {
            keywordsError2.enter(inliningTarget);
            throw KwargsMergeNode.handleNonMapping(frame, inliningTarget, raise, stackTop, e);
        }
        return stackTop;
    }

    public static KwargsMergeNode create() {
        return KwargsMergeNodeGen.create();
    }

    public static KwargsMergeNode getUncached() {
        return KwargsMergeNodeGen.getUncached();
    }
}

