/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.str;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.lib.PyObjectAsciiNode;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectReprAsObjectNode;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public final class TemplateFormatter {
    private static final int ANS_INIT = 1;
    private static final int ANS_AUTO = 2;
    private static final int ANS_MANUAL = 3;
    private static final BigInteger MAXSIZE = BigInteger.valueOf(Integer.MAX_VALUE);
    private final String template;
    private String empty;
    private Object[] args;
    private Object keywords;
    private List<Object[]> parserList = null;
    private int autoNumbering;
    private int autoNumberingState;
    private int lastEnd = -1;

    public TemplateFormatter(TruffleString template) {
        this.template = template.toJavaStringUncached();
        this.empty = "";
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleString build(Node node, Object[] argsArg, Object kwArgs, BuiltinFunctions.FormatNode formatNode) {
        this.args = argsArg;
        this.keywords = kwArgs;
        this.autoNumbering = 0;
        this.autoNumberingState = 1;
        return this.buildString(node, 0, this.template.length(), 2, formatNode);
    }

    private TruffleString buildString(Node node, int start, int end, int level, BuiltinFunctions.FormatNode formatNode) {
        if (level == 0) {
            throw PRaiseNode.raiseStatic(node, PythonErrorType.ValueError, ErrorMessages.RECURSION_DEPTH_EXCEEDED);
        }
        return this.doBuildString(node, start, end, level - 1, this.template, formatNode);
    }

    private TruffleString doBuildString(Node node, int start, int end, int level, String s, BuiltinFunctions.FormatNode formatNode) {
        StringBuilder out = new StringBuilder();
        int lastLiteral = start;
        int i = start;
        while (i < end) {
            char c = s.charAt(i);
            ++i;
            if (c != '{' && c != '}') continue;
            boolean atEnd = i == end;
            boolean markupFollows = true;
            if (c == '}') {
                if (atEnd || s.charAt(i) != '}') {
                    throw PRaiseNode.raiseStatic(node, PythonErrorType.ValueError, ErrorMessages.SINGLE_RBRACE_ENCOUNTERED_IN_FORMAT_STRING);
                }
                ++i;
                markupFollows = false;
            }
            if (c == '{') {
                if (atEnd) {
                    throw PRaiseNode.raiseStatic(node, PythonErrorType.ValueError, ErrorMessages.SINGLE_RBRACE_ENCOUNTERED_IN_FORMAT_STRING);
                }
                if (s.charAt(i) == '{') {
                    ++i;
                    markupFollows = false;
                }
            }
            out.append(s, lastLiteral, i - 1);
            if (!markupFollows) {
                if (this.parserList != null) {
                    int endLiteral = i - 1;
                    assert (endLiteral > lastLiteral);
                    TruffleString literal = PythonUtils.toTruffleStringUncached(this.template.substring(lastLiteral, endLiteral));
                    this.parserList.add(new Object[]{literal, PNone.NONE, PNone.NONE, PNone.NONE});
                    this.lastEnd = i;
                }
                lastLiteral = i;
                continue;
            }
            int nested = 1;
            int fieldStart = i;
            boolean recursive = false;
            while (i < end) {
                c = s.charAt(i);
                if (c == '{') {
                    recursive = true;
                    ++nested;
                } else if (c == '}') {
                    if (--nested == 0) {
                        break;
                    }
                } else if (c == '[') {
                    ++i;
                    while (i < end && s.charAt(i) != ']') {
                        ++i;
                    }
                    continue;
                }
                ++i;
            }
            if (nested > 0) {
                throw PRaiseNode.raiseStatic(node, PythonErrorType.ValueError, ErrorMessages.EXPECTED_RBRACE_BEFORE_END_OF_STRING);
            }
            Object rendered = this.renderField(node, fieldStart, i, recursive, level, formatNode);
            out.append(rendered);
            lastLiteral = ++i;
        }
        out.append(s.substring(lastLiteral, end));
        return PythonUtils.toTruffleStringUncached(out.toString());
    }

    private Field parseField(Node node, int start, int end) {
        String s = this.template;
        for (int i = start; i < end; ++i) {
            char c = s.charAt(i);
            Character conversion = null;
            if (c == ':' || c == '!') {
                int endName = i++;
                if (c == '!') {
                    if (i == end) {
                        throw PRaiseNode.raiseStatic(node, PythonErrorType.ValueError, ErrorMessages.EXPECTED_CONVERSION);
                    }
                    conversion = Character.valueOf(s.charAt(i));
                    if (++i < end) {
                        if (s.charAt(i) != ':') {
                            throw PRaiseNode.raiseStatic(node, PythonErrorType.ValueError, ErrorMessages.EXPECTED_S_AFTER_FORMAT_CONVERSION, Character.valueOf(':'));
                        }
                        ++i;
                    }
                } else {
                    conversion = null;
                    ++i;
                }
                return new Field(s.substring(start, endName), conversion, i);
            }
            if (c == '[') {
                while (i + 1 < end && s.charAt(i + 1) != ']') {
                    ++i;
                }
                continue;
            }
            if (c != '{') continue;
            throw PRaiseNode.raiseStatic(node, PythonErrorType.ValueError, ErrorMessages.UNEXPECTED_S_IN_FIELD_NAME, "'{'");
        }
        return new Field(s.substring(start, end), null, end);
    }

    private Object getArgument(Node node, String name) {
        boolean useNumeric;
        char c;
        int i;
        int end = name.length();
        for (i = 0; i < end && (c = name.charAt(i)) != '[' && c != '.'; ++i) {
        }
        boolean isEmpty = i == 0;
        String intString = name.substring(0, i);
        int index = isEmpty ? -1 : TemplateFormatter.toInt(node, intString);
        boolean bl = useNumeric = isEmpty || index != -1;
        if (this.autoNumberingState == 1 && useNumeric) {
            this.autoNumberingState = isEmpty ? 2 : 3;
        }
        if (useNumeric) {
            if (this.autoNumberingState == 3) {
                if (isEmpty) {
                    throw PRaiseNode.raiseStatic(node, PythonErrorType.ValueError, ErrorMessages.SWITCHING_FROM_MANUAL_TO_AUTOMATIC_NUMBERING);
                }
            } else if (!isEmpty) {
                throw PRaiseNode.raiseStatic(node, PythonErrorType.ValueError, ErrorMessages.SWITCHING_FROM_AUTOMATIC_TO_MANUAL_NUMBERING);
            }
        }
        if (isEmpty) {
            index = this.autoNumbering++;
        }
        Object arg = null;
        if (index == -1) {
            String kwarg = intString;
            arg = this.getKeyword(node, kwarg);
        } else {
            if (index > Integer.MAX_VALUE) {
                throw PRaiseNode.raiseStatic(node, PythonErrorType.ValueError, ErrorMessages.TOO_MANY_DECIMAL_DIGITS_IN_FORMAT_STRING);
            }
            if (this.args == null) {
                throw PRaiseNode.raiseStatic(node, PythonErrorType.ValueError, ErrorMessages.FORMAT_STR_CONTAINS_POS_FIELDS);
            }
            if (index >= this.args.length) {
                throw PRaiseNode.raiseStatic(node, PythonErrorType.IndexError, ErrorMessages.REPLACEMENT_INDEX_S_OUT_OF_RANGE, index);
            }
            arg = this.args[index];
        }
        return this.resolveLookups(node, arg, name, i, end);
    }

    private Object resolveLookups(Node node, Object obj, String name, int startArg, int end) {
        int i = startArg;
        int start = startArg;
        Object result = obj;
        while (i < end) {
            char c = name.charAt(i);
            if (c == '.') {
                start = ++i;
                while (i < end && (c = name.charAt(i)) != '[' && c != '.') {
                    ++i;
                }
                if (start == i) {
                    throw PRaiseNode.raiseStatic(node, PythonErrorType.ValueError, ErrorMessages.EMPTY_ATTR_IN_FORMAT_STR);
                }
                TruffleString attr = PythonUtils.toTruffleStringUncached(name.substring(start, i));
                if (result != null) {
                    result = PyObjectLookupAttr.executeUncached(result, attr);
                    continue;
                }
                this.parserList.add(new Object[]{true, attr});
                continue;
            }
            if (c == '[') {
                boolean gotBracket = false;
                start = ++i;
                while (i < end) {
                    c = name.charAt(i);
                    if (c == ']') {
                        gotBracket = true;
                        break;
                    }
                    ++i;
                }
                if (!gotBracket) {
                    throw PRaiseNode.raiseStatic(node, PythonErrorType.ValueError, ErrorMessages.MISSING_S, "']'");
                }
                String s = name.substring(start, i);
                if (s.isEmpty()) {
                    throw PRaiseNode.raiseStatic(node, PythonErrorType.ValueError, ErrorMessages.EMPTY_ATTR_IN_FORMAT_STR);
                }
                int index = TemplateFormatter.toInt(node, s);
                Integer item = index != -1 ? Integer.valueOf(index) : PythonUtils.toTruffleStringUncached(s);
                ++i;
                if (result != null) {
                    result = PyObjectGetItem.executeUncached(result, item);
                    continue;
                }
                this.parserList.add(new Object[]{false, item});
                continue;
            }
            throw PRaiseNode.raiseStatic(node, PythonErrorType.ValueError, ErrorMessages.ONLY_S_AND_S_AMY_FOLLOW_S, "'['", "'.'", "']'");
        }
        return result;
    }

    private static int toInt(Node node, String s) {
        try {
            BigInteger bigInt = new BigInteger(s);
            if (bigInt.signum() >= 0) {
                return bigInt.intValueExact();
            }
            return -1;
        }
        catch (NumberFormatException e) {
            return -1;
        }
        catch (ArithmeticException e) {
            throw PRaiseNode.raiseStatic(node, PythonErrorType.ValueError, ErrorMessages.TOO_MANY_DECIMAL_DIGITS_IN_FORMAT_STRING);
        }
    }

    private Object renderField(Node node, int start, int end, boolean recursive, int level, BuiltinFunctions.FormatNode formatNode) {
        Field filed = this.parseField(node, start, end);
        String name = filed.name;
        Character conversion = filed.conversion;
        int specStart = filed.idx;
        TruffleString spec = PythonUtils.toTruffleStringUncached(this.template.substring(specStart, end));
        if (this.parserList != null) {
            if (level == 1) {
                int startm1 = start - 1;
                assert (startm1 >= this.lastEnd);
                this.parserList.add(new Object[]{PythonUtils.toTruffleStringUncached(this.template.substring(this.lastEnd, startm1)), PythonUtils.toTruffleStringUncached(name), spec, conversion != null ? PythonUtils.toTruffleStringUncached(Character.toString(conversion.charValue())) : PNone.NONE});
                this.lastEnd = end + 1;
            }
            return this.empty;
        }
        Object obj = this.getArgument(node, name);
        if (conversion != null) {
            obj = TemplateFormatter.convert(node, obj, conversion.charValue());
        }
        if (recursive) {
            spec = this.buildString(node, specStart, end, level, formatNode);
        }
        Object rendered = formatNode.execute(null, obj, spec);
        return rendered;
    }

    @CompilerDirectives.TruffleBoundary
    public FieldNameSplitResult formatterFieldNameSplit(Node node) {
        int index;
        char c;
        int i;
        String name = this.template;
        int end = name.length();
        for (i = 0; i < end && (c = name.charAt(i)) != '[' && c != '.'; ++i) {
        }
        if (i == 0) {
            index = -1;
        } else {
            try {
                index = Integer.parseInt(name.substring(0, i));
            }
            catch (NumberFormatException e) {
                index = -1;
            }
        }
        Integer first = index >= 0 ? Integer.valueOf(index) : PythonUtils.toTruffleStringUncached(name.substring(0, i));
        this.parserList = new ArrayList<Object[]>();
        this.resolveLookups(node, null, name, i, end);
        return new FieldNameSplitResult(first, this.parserList);
    }

    private static Object convert(Node node, Object obj, char conversion) {
        switch (conversion) {
            case 'r': {
                return PyObjectReprAsObjectNode.executeUncached(obj);
            }
            case 's': {
                return PyObjectStrAsTruffleStringNode.executeUncached(obj);
            }
            case 'a': {
                return PyObjectAsciiNode.executeUncached(obj);
            }
        }
        throw PRaiseNode.raiseStatic(node, PythonErrorType.ValueError, ErrorMessages.INVALID_CONVERSION);
    }

    @CompilerDirectives.TruffleBoundary
    public List<Object[]> formatterParser(Node node) {
        this.parserList = new ArrayList<Object[]>();
        this.lastEnd = 0;
        this.buildString(node, 0, this.template.length(), 2, null);
        if (this.lastEnd < this.template.length()) {
            this.parserList.add(new Object[]{PythonUtils.toTruffleStringUncached(this.template.substring(this.lastEnd)), PNone.NONE, PNone.NONE, PNone.NONE});
        }
        return this.parserList;
    }

    private Object getKeyword(Node node, String key) {
        TruffleString tKey = PythonUtils.toTruffleStringUncached(key);
        if (this.keywords instanceof PKeyword[]) {
            for (PKeyword kwArg : (PKeyword[])this.keywords) {
                if (!tKey.equalsUncached((AbstractTruffleString)kwArg.getName(), PythonUtils.TS_ENCODING)) continue;
                return kwArg.getValue();
            }
        } else {
            Object result = PyObjectGetItem.executeUncached(this.keywords, tKey);
            if (result != null) {
                return result;
            }
        }
        throw PRaiseNode.raiseStatic(node, PythonBuiltinClassType.KeyError, tKey);
    }

    private static class Field {
        String name;
        Character conversion;
        int idx;

        public Field(String name, Character conversion, int idx) {
            this.name = name;
            this.conversion = conversion;
            this.idx = idx;
        }
    }

    public static class FieldNameSplitResult {
        public Object first;
        public List<Object[]> parserList;

        public FieldNameSplitResult(Object first, List<Object[]> parserList) {
            this.first = first;
            this.parserList = parserList;
        }
    }
}

