/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime.hotspot.libgraal;

class LibGraalScopedHandle
implements AutoCloseable {
    private long handle;
    private final Class<?> handleType;

    LibGraalScopedHandle(long handle, Class<?> handleType) {
        this.handle = handle;
        this.handleType = handleType;
    }

    long getHandle() {
        if (this.handle == 0L) {
            throw new IllegalStateException("Using invalid handle to " + this.handleType.getName() + " object in libgraal heap");
        }
        return this.handle;
    }

    @Override
    public void close() {
        this.handle = 0L;
    }

    public String toString() {
        return String.format("%s@0x%x", this.handleType.getName(), this.handle);
    }
}

