/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.compiler;

import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.compiler.SourceMap;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class CodeUnit {
    public final TruffleString name;
    public final TruffleString qualname;
    public final int argCount;
    public final int kwOnlyArgCount;
    public final int positionalOnlyArgCount;
    public final int flags;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final TruffleString[] names;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final TruffleString[] varnames;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final TruffleString[] cellvars;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final TruffleString[] freevars;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final int[] cell2arg;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final int[] arg2cell;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final Object[] constants;
    public final int startLine;
    public final int startColumn;
    public final int endLine;
    public final int endColumn;

    public CodeUnit(TruffleString name, TruffleString qualname, int argCount, int kwOnlyArgCount, int positionalOnlyArgCount, int flags, TruffleString[] names, TruffleString[] varnames, TruffleString[] cellvars, TruffleString[] freevars, int[] cell2arg, Object[] constants, int startLine, int startColumn, int endLine, int endColumn) {
        this.name = name;
        this.qualname = qualname != null ? qualname : name;
        this.argCount = argCount;
        this.kwOnlyArgCount = kwOnlyArgCount;
        this.positionalOnlyArgCount = positionalOnlyArgCount;
        this.flags = flags;
        this.names = names;
        this.varnames = varnames;
        this.cellvars = cellvars;
        this.freevars = freevars;
        this.cell2arg = cell2arg;
        int[] arg2cellValue = null;
        if (cell2arg != null) {
            arg2cellValue = new int[this.getTotalArgCount()];
            Arrays.fill(arg2cellValue, -1);
            for (int i = 0; i < cell2arg.length; ++i) {
                if (cell2arg[i] < 0) continue;
                arg2cellValue[cell2arg[i]] = i;
            }
        }
        this.arg2cell = arg2cellValue;
        this.constants = constants;
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public SourceSection getSourceSection(Source source) {
        return SourceMap.getSourceSection(source, this.startLine, this.startColumn, this.endLine, this.endColumn);
    }

    public boolean takesVarKeywordArgs() {
        return (this.flags & 8) != 0;
    }

    public boolean takesVarArgs() {
        return (this.flags & 4) != 0;
    }

    public boolean isGenerator() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isCoroutine() {
        return (this.flags & 0x80) != 0;
    }

    public boolean isAsyncGenerator() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isGeneratorOrCoroutine() {
        return (this.flags & 0x3A0) != 0;
    }

    public int getRegularArgCount() {
        return this.argCount + this.positionalOnlyArgCount + this.kwOnlyArgCount;
    }

    public int getTotalArgCount() {
        int count = this.getRegularArgCount();
        if (this.takesVarArgs()) {
            ++count;
        }
        if (this.takesVarKeywordArgs()) {
            ++count;
        }
        return count;
    }

    public final Signature computeSignature() {
        int posArgCount = this.argCount + this.positionalOnlyArgCount;
        TruffleString[] parameterNames = Arrays.copyOf(this.varnames, posArgCount);
        TruffleString[] kwOnlyNames = Arrays.copyOfRange(this.varnames, posArgCount, posArgCount + this.kwOnlyArgCount);
        int varArgsIndex = this.takesVarArgs() ? posArgCount : -1;
        return new Signature(this.positionalOnlyArgCount, this.takesVarKeywordArgs(), varArgsIndex, parameterNames, kwOnlyNames);
    }

    public String toString() {
        return this.toString(false);
    }

    protected abstract void dumpBytecode(StringBuilder var1, boolean var2);

    public String toString(boolean optimized) {
        StringBuilder sb = new StringBuilder();
        sb.append("Disassembly of ").append(this.qualname).append(":\n");
        ArrayList<String> flagNames = new ArrayList<String>();
        if (this.isGenerator()) {
            flagNames.add("CO_GENERATOR");
        }
        if (this.isCoroutine()) {
            flagNames.add("CO_COROUTINE");
        }
        if (this.isAsyncGenerator()) {
            flagNames.add("CO_ASYNC_GENERATOR");
        }
        if (!flagNames.isEmpty()) {
            sb.append("Flags: ").append(String.join((CharSequence)" | ", flagNames)).append("\n");
        }
        this.dumpBytecode(sb, optimized);
        for (Object c : this.constants) {
            if (!(c instanceof CodeUnit)) continue;
            CodeUnit cd = (CodeUnit)c;
            sb.append('\n');
            sb.append(cd.toString(optimized));
        }
        return sb.toString();
    }
}

