/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.function;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.WrapperDescriptorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.function.WrapperDescriptorBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.method.PMethod;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGet;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.WrapperDescriptor})
public final class WrapperDescriptorBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = WrapperDescriptorBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return WrapperDescriptorBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString reprClassFunction(PBuiltinFunction self, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            if (self.getEnclosingType() == null) {
                return simpleTruffleStringFormatNode.format("<builtin_function_or_method '%s'>", self.getName());
            }
            return simpleTruffleStringFormatNode.format("<slot wrapper '%s' of '%s' objects>", self.getName(), TypeNodes.GetNameNode.executeUncached(self.getEnclosingType()));
        }
    }

    @Slot(value=Slot.SlotKind.tp_descr_get)
    @GenerateUncached
    @GenerateNodeFactory
    public static abstract class GetNode
    extends TpSlotDescrGet.DescrGetBuiltinNode {
        @Specialization(guards={"!isNoValue(instance)"})
        static PMethod doMethod(PFunction self, Object instance, Object klass, @Bind PythonLanguage language) {
            return PFactory.createMethod(language, (Object)PythonBuiltinClassType.MethodWrapper, PythonBuiltinClassType.MethodWrapper.getInstanceShape(language), instance, self);
        }

        @Specialization(guards={"isNoValue(instance)"})
        static Object doFunction(PFunction self, Object instance, Object klass) {
            return self;
        }

        @Specialization(guards={"!isNoValue(instance)"})
        static PBuiltinMethod doBuiltinMethod(PBuiltinFunction self, Object instance, Object klass, @Bind PythonLanguage language) {
            return PFactory.createBuiltinMethod(language, (Object)PythonBuiltinClassType.MethodWrapper, PythonBuiltinClassType.MethodWrapper.getInstanceShape(language), instance, self);
        }

        @Specialization(guards={"isNoValue(instance)"})
        static Object doBuiltinFunction(PBuiltinFunction self, Object instance, Object klass) {
            return self;
        }
    }
}

