/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotVarargs;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.BoundDescriptor;
import com.oracle.graal.python.nodes.call.CallDispatchers;
import com.oracle.graal.python.nodes.call.CallNodeGen;
import com.oracle.graal.python.nodes.call.ForeignMethod;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;

@ImportStatic(value={PGuards.class, SpecialMethodNames.class})
@GenerateUncached
@GenerateInline(value=false)
public abstract class CallNode
extends PNodeWithContext {
    @NeverDefault
    public static CallNode create() {
        return CallNodeGen.create();
    }

    public static CallNode getUncached() {
        return CallNodeGen.getUncached();
    }

    protected abstract Object executeInternal(Frame var1, Object var2, Object[] var3, PKeyword[] var4);

    public final Object executeWithoutFrame(Object callableObject, Object[] arguments, PKeyword[] keywords) {
        return this.executeInternal(null, callableObject, arguments, keywords);
    }

    public static Object executeUncached(Object callableObject, Object[] arguments, PKeyword[] keywords) {
        return CallNode.getUncached().executeInternal(null, callableObject, arguments, keywords);
    }

    public final Object executeWithoutFrame(Object callableObject, Object ... arguments) {
        return this.executeInternal(null, callableObject, arguments, PKeyword.EMPTY_KEYWORDS);
    }

    public static Object executeUncached(Object callableObject, Object ... arguments) {
        return CallNode.getUncached().executeInternal(null, callableObject, arguments, PKeyword.EMPTY_KEYWORDS);
    }

    public final Object execute(Frame frame, Object callableObject, Object[] arguments, PKeyword[] keywords) {
        return this.executeInternal(frame, callableObject, arguments, keywords);
    }

    public final Object execute(Frame frame, Object callableObject, Object ... arguments) {
        return this.executeInternal(frame, callableObject, arguments, PKeyword.EMPTY_KEYWORDS);
    }

    @Specialization
    static Object boundDescriptor(VirtualFrame frame, BoundDescriptor descriptor, Object[] arguments, PKeyword[] keywords, @Cached CallNode subNode) {
        return subNode.executeInternal((Frame)frame, descriptor.descriptor, PythonUtils.arrayCopyOfRange(arguments, 1, arguments.length), keywords);
    }

    @Specialization
    static Object functionCall(VirtualFrame frame, PFunction callable, Object[] arguments, PKeyword[] keywords, @Bind Node inliningTarget, @Cached CallDispatchers.FunctionCachedCallNode callNode) {
        return callNode.execute(frame, inliningTarget, callable, arguments, keywords);
    }

    @Specialization
    static Object builtinFunctionCall(VirtualFrame frame, PBuiltinFunction callable, Object[] arguments, PKeyword[] keywords, @Bind Node inliningTarget, @Cached CallDispatchers.BuiltinFunctionCachedCallNode callNode) {
        return callNode.execute(frame, inliningTarget, callable, arguments, keywords);
    }

    @Specialization
    @HostCompilerDirectives.InliningCutoff
    protected static Object doForeignMethod(ForeignMethod callable, Object[] arguments, PKeyword[] keywords, @Bind Node inliningTarget, @Cached PForeignToPTypeNode fromForeign, @Cached InlinedBranchProfile keywordsError, @Cached InlinedBranchProfile typeError, @Cached GilNode gil, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary interop) {
        if (keywords.length != 0) {
            keywordsError.enter(inliningTarget);
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.INVALID_INSTANTIATION_OF_FOREIGN_OBJ);
        }
        gil.release(true);
        try {
            Object object = fromForeign.executeConvert(interop.invokeMember(callable.receiver, callable.methodName, arguments));
            return object;
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            typeError.enter(inliningTarget);
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, (Exception)e);
        }
        catch (UnknownIdentifierException e) {
            throw CompilerDirectives.shouldNotReachHere((String)"Cannot invoke member");
        }
        finally {
            gil.acquire();
        }
    }

    @Specialization
    static Object builtinMethodCall(VirtualFrame frame, PBuiltinMethod callable, Object[] arguments, PKeyword[] keywords, @Bind Node inliningTarget, @Cached CallDispatchers.BuiltinMethodCachedCallNode callNode) {
        return callNode.execute(frame, inliningTarget, callable, arguments, keywords);
    }

    @Fallback
    static Object doGeneric(VirtualFrame frame, Object callableObject, Object[] arguments, PKeyword[] keywords, @Bind Node inliningTarget, @Cached PRaiseNode raise, @Cached GetClassNode getClassNode, @Cached TpSlots.GetCachedTpSlotsNode getSlots, @Cached TpSlotVarargs.CallSlotTpCallNode callSlot) {
        Object type = getClassNode.execute(inliningTarget, callableObject);
        TpSlots slots = getSlots.execute(inliningTarget, type);
        if (slots.tp_call() != null) {
            return callSlot.execute(frame, inliningTarget, slots.tp_call(), callableObject, arguments, keywords);
        }
        throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_ISNT_CALLABLE, callableObject);
    }

    @GenerateInline
    @GenerateUncached
    @GenerateCached(value=false)
    public static abstract class Lazy
    extends Node {
        public final CallNode get(Node inliningTarget) {
            return this.execute(inliningTarget);
        }

        abstract CallNode execute(Node var1);

        @Specialization
        protected static CallNode doIt(@Cached(inline=false) CallNode callNode) {
            return callNode;
        }
    }
}

