/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.dict;

import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.DictNodes;
import com.oracle.graal.python.builtins.objects.dict.DictReprBuiltinFactory;
import com.oracle.graal.python.builtins.objects.dict.DictReprBuiltinSlotsGen;
import com.oracle.graal.python.builtins.objects.dict.PDictView;
import com.oracle.graal.python.builtins.objects.ordereddict.POrderedDict;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PDictKeysView, PythonBuiltinClassType.PDictItemsView, PythonBuiltinClassType.PDictValuesView, PythonBuiltinClassType.PDict})
public final class DictReprBuiltin
extends PythonBuiltins {
    public static final TpSlots SLOTS = DictReprBuiltinSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return DictReprBuiltinFactory.getFactories();
    }

    @GenerateInline(value=false)
    public static abstract class ReprOrderedDictItemsNode
    extends Node {
        public abstract void execute(VirtualFrame var1, POrderedDict var2, TruffleStringBuilder var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static void repr(VirtualFrame frame, POrderedDict dict, TruffleStringBuilder sb, @Bind Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod, @Cached PyObjectGetIter getIter, @Cached PyIterNextNode nextNode, @Cached FormatKeyValueDictRepr formatKeyValueDictRepr) {
            Object oditems = callMethod.execute((Frame)frame, inliningTarget, dict, SpecialMethodNames.T_ITEMS, new Object[0]);
            ReprNode.ReprState s = new ReprNode.ReprState(dict, sb, false);
            int count = 0;
            try {
                Object iter = getIter.execute((Frame)frame, inliningTarget, oditems);
                while (true) {
                    Object next;
                    try {
                        next = nextNode.execute((Frame)frame, inliningTarget, iter);
                    }
                    catch (IteratorExhausted e) {
                        break;
                    }
                    if (CompilerDirectives.hasNextTier()) {
                        ++count;
                    }
                    assert (PGuards.isPTuple(next));
                    ObjectSequenceStorage item = (ObjectSequenceStorage)((PTuple)next).getSequenceStorage();
                    Object key = item.getObjectItemNormalized(0);
                    Object value = item.getObjectItemNormalized(1);
                    formatKeyValueDictRepr.execute(key, value, s);
                }
            }
            finally {
                if (count != 0) {
                    LoopNode.reportLoopCount((Node)inliningTarget, (int)count);
                }
            }
        }
    }

    @GenerateInline(value=false)
    public static abstract class FormatKeyValueDictRepr
    extends Node {
        abstract void execute(Object var1, Object var2, ReprNode.ReprState var3);

        @Specialization
        public static void keyValue(Object key, Object value, ReprNode.ReprState s, @Bind Node inliningTarget, @Cached LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode keyReprNode, @Cached LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode valueReprNode, @Cached CastToTruffleStringNode castStr, @Cached PRaiseNode raiseNode, @Cached InlinedConditionProfile lengthCheck, @Cached TruffleStringBuilder.AppendStringNode appendStringNode) {
            TruffleString keyReprString = ReprNode.AbstractForEachRepr.getReprString(inliningTarget, key, null, keyReprNode, castStr, raiseNode);
            TruffleString valueReprString = ReprNode.AbstractForEachRepr.getReprString(inliningTarget, value, s, valueReprNode, castStr, raiseNode);
            ReprNode.AbstractForEachRepr.appendSeparator(inliningTarget, s, lengthCheck, appendStringNode);
            appendStringNode.execute(s.result, (AbstractTruffleString)keyReprString);
            appendStringNode.execute(s.result, (AbstractTruffleString)StringLiterals.T_COLON_SPACE);
            appendStringNode.execute(s.result, (AbstractTruffleString)valueReprString);
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        private static final TruffleString T_LPAREN_BRACKET = PythonUtils.tsLiteral("([");
        private static final TruffleString T_RPAREN_BRACKET = PythonUtils.tsLiteral("])");

        ReprNode() {
        }

        public abstract TruffleString execute(VirtualFrame var1, Object var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!isDictView(dict)"})
        public static TruffleString repr(Object dict, @Bind Node inliningTarget, @CachedLibrary(limit="2") InteropLibrary interopLib, @Cached DictNodes.GetDictStorageNode getStorageNode, @Cached(value="create(3)") ForEachDictRepr consumerNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageForEach forEachNode, @Cached.Shared @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached.Shared @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            PythonContext ctxt = PythonContext.get(forEachNode);
            Object reprIdentity = dict;
            if (!PGuards.isAnyPythonObject(dict) && interopLib.hasIdentity(dict)) {
                try {
                    reprIdentity = interopLib.identityHashCode(dict);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            if (!ctxt.reprEnter(reprIdentity)) {
                return StringLiterals.T_ELLIPSIS_IN_BRACES;
            }
            try {
                TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
                appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_LBRACE);
                HashingStorage storage = getStorageNode.execute(inliningTarget, dict);
                forEachNode.execute(null, inliningTarget, storage, consumerNode, new ReprState(dict, sb));
                appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_RBRACE);
                TruffleString truffleString = toStringNode.execute(sb);
                return truffleString;
            }
            finally {
                ctxt.reprLeave(reprIdentity);
            }
        }

        @Specialization
        public static TruffleString repr(PDictView.PDictKeysView view, @Bind Node inliningTarget, @Cached(value="create(3)") ForEachKeyRepr consumerNode, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached TypeNodes.GetNameNode getNameNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageForEach forEachNode, @Cached.Shared @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached.Shared @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            TruffleString typeName = getNameNode.execute(inliningTarget, getClassNode.execute(inliningTarget, view));
            return ReprNode.viewRepr(inliningTarget, view, typeName, forEachNode, consumerNode, appendStringNode, toStringNode);
        }

        @Specialization
        public static TruffleString repr(PDictView.PDictValuesView view, @Bind Node inliningTarget, @Cached(value="create(3)") ForEachValueRepr consumerNode, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached TypeNodes.GetNameNode getNameNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageForEach forEachNode, @Cached.Shared @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached.Shared @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            TruffleString typeName = getNameNode.execute(inliningTarget, getClassNode.execute(inliningTarget, view));
            return ReprNode.viewRepr(inliningTarget, view, typeName, forEachNode, consumerNode, appendStringNode, toStringNode);
        }

        @Specialization
        public static TruffleString repr(PDictView.PDictItemsView view, @Bind Node inliningTarget, @Cached(value="create(3)") ForEachItemRepr consumerNode, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached TypeNodes.GetNameNode getNameNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageForEach forEachNode, @Cached.Shared @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached.Shared @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            TruffleString typeName = getNameNode.execute(inliningTarget, getClassNode.execute(inliningTarget, view));
            return ReprNode.viewRepr(inliningTarget, view, typeName, forEachNode, consumerNode, appendStringNode, toStringNode);
        }

        private static TruffleString viewRepr(Node inliningTarget, PDictView view, TruffleString type, HashingStorageNodes.HashingStorageForEach forEachNode, AbstractForEachRepr consumerNode, TruffleStringBuilder.AppendStringNode appendStringNode, TruffleStringBuilder.ToStringNode toStringNode) {
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            appendStringNode.execute(sb, (AbstractTruffleString)type);
            appendStringNode.execute(sb, (AbstractTruffleString)T_LPAREN_BRACKET);
            HashingStorage dictStorage = view.getWrappedStorage();
            forEachNode.execute(null, inliningTarget, dictStorage, consumerNode, new ReprState(view, sb));
            appendStringNode.execute(sb, (AbstractTruffleString)T_RPAREN_BRACKET);
            return toStringNode.execute(sb);
        }

        @CompilerDirectives.ValueType
        protected static final class ReprState {
            private final Object self;
            private final TruffleStringBuilder result;
            private final int initialLength;
            private final boolean ellipsisInBraces;

            ReprState(Object self, TruffleStringBuilder result) {
                this(self, result, true);
            }

            ReprState(Object self, TruffleStringBuilder result, boolean ellipsisInBraces) {
                this.self = self;
                this.result = result;
                this.ellipsisInBraces = ellipsisInBraces;
                this.initialLength = result.byteLength();
            }
        }

        static abstract class AbstractForEachRepr
        extends HashingStorageNodes.HashingStorageForEachCallback<ReprState> {
            private final int limit;

            AbstractForEachRepr(int limit) {
                this.limit = limit;
            }

            protected final int getLimit() {
                return this.limit;
            }

            @Override
            public abstract ReprState execute(Frame var1, Node var2, HashingStorage var3, HashingStorageNodes.HashingStorageIterator var4, ReprState var5);

            protected static TruffleString getReprString(Node inliningTarget, Object obj, ReprState s, LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode reprNode, CastToTruffleStringNode castStr, PRaiseNode raiseNode) {
                TruffleString ellipsisStr = s == null || s.ellipsisInBraces ? StringLiterals.T_ELLIPSIS_IN_BRACES : StringLiterals.T_ELLIPSIS;
                Object reprObj = s == null || obj != s.self ? reprNode.executeObject(obj, SpecialMethodNames.T___REPR__) : ellipsisStr;
                try {
                    return castStr.execute(inliningTarget, reprObj);
                }
                catch (CannotCastException e) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.RETURNED_NON_STRING, "__repr__", reprObj);
                }
            }

            protected static void appendSeparator(Node inliningTarget, ReprState s, InlinedConditionProfile lengthCheck, TruffleStringBuilder.AppendStringNode appendStringNode) {
                if (lengthCheck.profile(inliningTarget, s.result.byteLength() > s.initialLength)) {
                    appendStringNode.execute(s.result, (AbstractTruffleString)StringLiterals.T_COMMA_SPACE);
                }
            }
        }

        static abstract class ForEachDictRepr
        extends AbstractForEachRepr {
            public ForEachDictRepr(int limit) {
                super(limit);
            }

            @Specialization
            public static ReprState dict(Frame frame, Node node, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, ReprState s, @Bind Node inliningTarget, @Cached LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode keyReprNode, @Cached LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode valueReprNode, @Cached CastToTruffleStringNode castStr, @Cached PRaiseNode raiseNode, @Cached InlinedConditionProfile lengthCheck, @Cached HashingStorageNodes.HashingStorageIteratorKey itKey, @Cached HashingStorageNodes.HashingStorageIteratorValue itValue, @Cached TruffleStringBuilder.AppendStringNode appendStringNode) {
                Object key = itKey.execute(inliningTarget, storage, it);
                Object value = itValue.execute(inliningTarget, storage, it);
                TruffleString keyReprString = ForEachDictRepr.getReprString(inliningTarget, key, null, keyReprNode, castStr, raiseNode);
                TruffleString valueReprString = ForEachDictRepr.getReprString(inliningTarget, value, s, valueReprNode, castStr, raiseNode);
                ForEachDictRepr.appendSeparator(inliningTarget, s, lengthCheck, appendStringNode);
                appendStringNode.execute(s.result, (AbstractTruffleString)keyReprString);
                appendStringNode.execute(s.result, (AbstractTruffleString)StringLiterals.T_COLON_SPACE);
                appendStringNode.execute(s.result, (AbstractTruffleString)valueReprString);
                return s;
            }
        }

        static abstract class ForEachItemRepr
        extends AbstractForEachRepr {
            public ForEachItemRepr(int limit) {
                super(limit);
            }

            @Specialization
            public static ReprState dict(Frame frame, Node node, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, ReprState s, @Bind Node inliningTarget, @Cached LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode keyReprNode, @Cached LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode valueReprNode, @Cached CastToTruffleStringNode castStr, @Cached PRaiseNode raiseNode, @Cached InlinedConditionProfile lengthCheck, @Cached HashingStorageNodes.HashingStorageIteratorKey itKey, @Cached HashingStorageNodes.HashingStorageIteratorValue itValue, @Cached TruffleStringBuilder.AppendStringNode appendStringNode) {
                ForEachItemRepr.appendSeparator(inliningTarget, s, lengthCheck, appendStringNode);
                appendStringNode.execute(s.result, (AbstractTruffleString)StringLiterals.T_LPAREN);
                Object key = itKey.execute(inliningTarget, storage, it);
                Object value = itValue.execute(inliningTarget, storage, it);
                appendStringNode.execute(s.result, (AbstractTruffleString)ForEachItemRepr.getReprString(inliningTarget, key, null, keyReprNode, castStr, raiseNode));
                appendStringNode.execute(s.result, (AbstractTruffleString)StringLiterals.T_COMMA_SPACE);
                appendStringNode.execute(s.result, (AbstractTruffleString)ForEachItemRepr.getReprString(inliningTarget, value, s, valueReprNode, castStr, raiseNode));
                appendStringNode.execute(s.result, (AbstractTruffleString)StringLiterals.T_RPAREN);
                return s;
            }
        }

        static abstract class ForEachValueRepr
        extends AbstractForEachRepr {
            public ForEachValueRepr(int limit) {
                super(limit);
            }

            @Specialization
            public static ReprState dict(Frame frame, Node node, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, ReprState s, @Bind Node inliningTarget, @Cached LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode reprNode, @Cached CastToTruffleStringNode castStr, @Cached PRaiseNode raiseNode, @Cached InlinedConditionProfile lengthCheck, @Cached HashingStorageNodes.HashingStorageIteratorValue itValue, @Cached TruffleStringBuilder.AppendStringNode appendStringNode) {
                ForEachValueRepr.appendSeparator(inliningTarget, s, lengthCheck, appendStringNode);
                Object value = itValue.execute(inliningTarget, storage, it);
                appendStringNode.execute(s.result, (AbstractTruffleString)ForEachValueRepr.getReprString(inliningTarget, value, s, reprNode, castStr, raiseNode));
                return s;
            }
        }

        static abstract class ForEachKeyRepr
        extends AbstractForEachRepr {
            public ForEachKeyRepr(int limit) {
                super(limit);
            }

            @Specialization
            public static ReprState append(Node node, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, ReprState s, @Bind Node inliningTarget, @Cached LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode reprNode, @Cached CastToTruffleStringNode castStr, @Cached PRaiseNode raiseNode, @Cached InlinedConditionProfile lengthCheck, @Cached HashingStorageNodes.HashingStorageIteratorKey itKey, @Cached TruffleStringBuilder.AppendStringNode appendStringNode) {
                ForEachKeyRepr.appendSeparator(inliningTarget, s, lengthCheck, appendStringNode);
                Object key = itKey.execute(inliningTarget, storage, it);
                appendStringNode.execute(s.result, (AbstractTruffleString)ForEachKeyRepr.getReprString(inliningTarget, key, null, reprNode, castStr, raiseNode));
                return s;
            }
        }
    }
}

