/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.encoder.servlet;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.messaging.encoder.servlet.AbstractHttpServletResponseMessageEncoder;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public abstract class BaseHttpServletResponseXMLMessageEncoder
extends AbstractHttpServletResponseMessageEncoder {
    @Nonnull
    private Logger protocolMessageLog = LoggerFactory.getLogger("PROTOCOL_MESSAGE");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseHttpServletResponseXMLMessageEncoder.class);

    @Override
    public void encode() throws MessageEncodingException {
        Object msg;
        MessageContext mc;
        if (this.log.isDebugEnabled() && (mc = this.getMessageContext()) != null && (msg = mc.getMessage()) != null) {
            this.log.debug("Beginning encode of message of type: {}", (Object)msg.getClass().getName());
        }
        super.encode();
        this.log.debug("Successfully encoded message.");
    }

    @Override
    @Nullable
    protected String serializeMessageForLogging(@Nullable Object message) {
        if (message == null || !XMLObject.class.isInstance(message)) {
            this.log.debug("Message was null or unsupported, can not serialize");
            return null;
        }
        try {
            Element dom = XMLObjectSupport.marshall((XMLObject)XMLObject.class.cast(message));
            return SerializeSupport.prettyPrintXML(dom);
        }
        catch (MarshallingException e) {
            this.log.error("Unable to marshall message for logging purposes", (Throwable)e);
            return null;
        }
    }

    @Nonnull
    protected Element marshallMessage(@Nonnull XMLObject message) throws MessageEncodingException {
        this.log.debug("Marshalling message");
        try {
            return XMLObjectSupport.marshall(message);
        }
        catch (MarshallingException e) {
            this.log.error("Error marshalling message: {}", (Object)e.getMessage());
            throw new MessageEncodingException("Error marshalling message", e);
        }
    }
}

