/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.search.aggregations.metrics.PercentilesConfig;

public enum PercentilesMethod implements Writeable
{
    TDIGEST("tdigest", new String[]{"TDigest", "TDIGEST"}){

        @Override
        PercentilesConfig configFromStream(StreamInput in) throws IOException {
            return new PercentilesConfig.TDigest(in);
        }
    }
    ,
    HDR("hdr", new String[]{"HDR"}){

        @Override
        PercentilesConfig configFromStream(StreamInput in) throws IOException {
            return new PercentilesConfig.Hdr(in);
        }
    };

    public static final ParseField COMPRESSION_FIELD;
    public static final ParseField NUMBER_SIGNIFICANT_DIGITS_FIELD;
    public static final ObjectParser<PercentilesConfig.TDigest, String> TDIGEST_PARSER;
    public static final ObjectParser<PercentilesConfig.Hdr, String> HDR_PARSER;
    private final ParseField parseField;

    private PercentilesMethod(String name, String ... deprecatedNames) {
        this.parseField = new ParseField(name, deprecatedNames);
    }

    abstract PercentilesConfig configFromStream(StreamInput var1) throws IOException;

    public ParseField getParseField() {
        return this.parseField;
    }

    public static PercentilesMethod readFromStream(StreamInput in) throws IOException {
        return (PercentilesMethod)in.readEnum(PercentilesMethod.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this);
    }

    public String toString() {
        return this.parseField.getPreferredName();
    }

    static {
        COMPRESSION_FIELD = new ParseField("compression", new String[0]);
        NUMBER_SIGNIFICANT_DIGITS_FIELD = new ParseField("number_of_significant_value_digits", new String[0]);
        TDIGEST_PARSER = new ObjectParser(TDIGEST.getParseField().getPreferredName(), PercentilesConfig.TDigest::new);
        TDIGEST_PARSER.declareDouble(PercentilesConfig.TDigest::setCompression, COMPRESSION_FIELD);
        HDR_PARSER = new ObjectParser(HDR.getParseField().getPreferredName(), PercentilesConfig.Hdr::new);
        HDR_PARSER.declareInt(PercentilesConfig.Hdr::setNumberOfSignificantValueDigits, NUMBER_SIGNIFICANT_DIGITS_FIELD);
    }
}

