/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.TemporalType;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.compare.CalendarComparator;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalJavaType;
import org.hibernate.type.descriptor.java.CalendarDateJavaType;
import org.hibernate.type.descriptor.java.CalendarJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JdbcTimeJavaType;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class CalendarTimeJavaType
extends AbstractTemporalJavaType<Calendar> {
    public static final CalendarTimeJavaType INSTANCE = new CalendarTimeJavaType();

    protected CalendarTimeJavaType() {
        super(Calendar.class, CalendarJavaType.CalendarMutabilityPlan.INSTANCE, CalendarComparator.INSTANCE);
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIME;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        return context.getJdbcType(92);
    }

    @Override
    protected <X> TemporalJavaType<X> forTimePrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    @Override
    protected <X> TemporalJavaType<X> forTimestampPrecision(TypeConfiguration typeConfiguration) {
        return CalendarJavaType.INSTANCE;
    }

    @Override
    protected <X> TemporalJavaType<X> forDatePrecision(TypeConfiguration typeConfiguration) {
        return CalendarDateJavaType.INSTANCE;
    }

    @Override
    public String toString(Calendar value) {
        return JdbcTimeJavaType.INSTANCE.toString(value.getTime());
    }

    @Override
    public Calendar fromString(CharSequence string) {
        GregorianCalendar result = new GregorianCalendar();
        result.setTime(JdbcTimeJavaType.INSTANCE.fromString(string.toString()));
        return result;
    }

    @Override
    public boolean areEqual(Calendar one, Calendar another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        return one.get(14) == another.get(14) && one.get(13) == another.get(13) && one.get(12) == another.get(12) && one.get(11) == another.get(11);
    }

    @Override
    public int extractHashCode(Calendar value) {
        int hashCode = 1;
        hashCode = 31 * hashCode + value.get(14);
        hashCode = 31 * hashCode + value.get(13);
        hashCode = 31 * hashCode + value.get(12);
        hashCode = 31 * hashCode + value.get(11);
        return hashCode;
    }

    @Override
    public <X> X unwrap(Calendar value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Date.class.isAssignableFrom(type)) {
            return (X)new Date(value.getTimeInMillis());
        }
        if (Time.class.isAssignableFrom(type)) {
            return (X)new Time(value.getTimeInMillis() % 86400000L);
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return (X)new Timestamp(value.getTimeInMillis());
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return (X)new java.util.Date(value.getTimeInMillis());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Calendar wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return calendar;
        }
        if (value instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)value;
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            return cal;
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public boolean isWider(JavaType<?> javaType) {
        return switch (javaType.getTypeName()) {
            case "java.sql.Time" -> true;
            default -> false;
        };
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return 0;
    }
}

