/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Color;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JTextPane;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.JSPrefs;

class LSConsoleTextPane
extends JTextPane {
    private final String STYLE_ROOT = "root";
    private final String STYLE_REGULAR = "regular";
    private final String STYLE_BOLD = "bold";
    private final String STYLE_NOTIFY_0 = "notificationMessage0";
    private final String STYLE_NOTIFY = "notificationMessage";
    private final String STYLE_WARN_0 = "warningMessage0";
    private final String STYLE_WARN = "warningMessage";
    private final String STYLE_ERROR_0 = "errorMessage0";
    private final String STYLE_ERROR = "errorMessage";
    private Color cmdColor;
    private Color notifyColor;
    private Color warnColor;
    private Color errorColor;

    LSConsoleTextPane() {
        int n = this.preferences().getIntProperty("LSConsole.textColor");
        this.cmdColor = new Color(n);
        n = this.preferences().getIntProperty("LSConsole.notifyColor");
        this.notifyColor = new Color(n);
        n = this.preferences().getIntProperty("LSConsole.errorColor");
        this.errorColor = new Color(n);
        n = this.preferences().getIntProperty("LSConsole.warningColor");
        this.warnColor = new Color(n);
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        StyledDocument styledDocument = this.getStyledDocument();
        Style style2 = styledDocument.addStyle("root", style);
        Style style3 = styledDocument.addStyle("regular", style2);
        Style style4 = styledDocument.addStyle("bold", style3);
        StyleConstants.setBold(style4, true);
        style4 = styledDocument.addStyle("notificationMessage0", style3);
        StyleConstants.setForeground(style4, this.notifyColor);
        styledDocument.addStyle("notificationMessage", style4);
        style4 = styledDocument.addStyle("warningMessage0", style3);
        StyleConstants.setForeground(style4, this.warnColor);
        styledDocument.addStyle("warningMessage", style4);
        style4 = styledDocument.addStyle("errorMessage0", style3);
        StyleConstants.setForeground(style4, this.errorColor);
        styledDocument.addStyle("errorMessage", style4);
        this.setEditable(false);
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    private JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    public void setTextColor(Color color) {
        this.cmdColor = color;
        StyledDocument styledDocument = this.getStyledDocument();
        Style style = styledDocument.getStyle("root");
        StyleConstants.setForeground(style, this.cmdColor);
    }

    public Color getTextColor() {
        return this.cmdColor;
    }

    public void setNotifyColor(Color color) {
        this.notifyColor = color;
        Style style = this.getStyledDocument().getStyle("notificationMessage0");
        StyleConstants.setForeground(style, this.notifyColor);
    }

    public Color getNotifyColor() {
        return this.notifyColor;
    }

    public Color getWarningColor() {
        return this.warnColor;
    }

    public void setWarningColor(Color color) {
        this.warnColor = color;
        Style style = this.getStyledDocument().getStyle("warningMessage0");
        StyleConstants.setForeground(style, this.warnColor);
    }

    public Color getErrorColor() {
        return this.errorColor;
    }

    public void setErrorColor(Color color) {
        this.errorColor = color;
        Style style = this.getStyledDocument().getStyle("errorMessage0");
        StyleConstants.setForeground(style, this.errorColor);
    }

    public void addCommand(String string) {
        StyledDocument styledDocument = this.getStyledDocument();
        try {
            String string2 = "lscp> ";
            styledDocument.insertString(styledDocument.getLength(), string2, styledDocument.getStyle("bold"));
            string2 = string + "\n";
            styledDocument.insertString(styledDocument.getLength(), string2, styledDocument.getStyle("regular"));
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.INFO, HF.getErrorMessage(exception), exception);
        }
    }

    public void addCommandResponse(String string) {
        StyledDocument styledDocument = this.getStyledDocument();
        try {
            String string2 = string + "\n";
            Style style = styledDocument.getStyle("regular");
            if (string2.startsWith("ERR:")) {
                style = styledDocument.getStyle("errorMessage");
            } else if (string2.startsWith("WRN:")) {
                style = styledDocument.getStyle("warningMessage");
            } else if (string2.startsWith("NOTIFY:")) {
                style = styledDocument.getStyle("notificationMessage");
            }
            styledDocument.insertString(styledDocument.getLength(), string2, style);
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.INFO, HF.getErrorMessage(exception), exception);
        }
    }
}

