/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resources;

import org.gradle.internal.resources.AbstractResourceLockRegistry;
import org.gradle.internal.resources.ProjectLockRegistry;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockContainer;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.TaskExecutionLock;
import org.gradle.util.Path;

public class TaskExecutionLockRegistry
extends AbstractResourceLockRegistry<Path, TaskExecutionLock> {
    private final ProjectLockRegistry projectLockRegistry;

    public TaskExecutionLockRegistry(ResourceLockCoordinationService coordinationService, ProjectLockRegistry projectLockRegistry) {
        super(coordinationService);
        this.projectLockRegistry = projectLockRegistry;
    }

    public ResourceLock getTaskExecutionLock(Path buildIdentityPath, Path projectIdentityPath) {
        if (this.projectLockRegistry.getAllowsParallelExecution()) {
            return this.getTaskExecutionLockForProject(projectIdentityPath, projectIdentityPath, buildIdentityPath);
        }
        return this.getTaskExecutionLockForBuild(buildIdentityPath, projectIdentityPath);
    }

    private TaskExecutionLock getTaskExecutionLockForProject(final Path projectIdentityPath, final Path projectIdentityPath1, final Path buildIdentityPath) {
        return this.getOrRegisterResourceLock(projectIdentityPath, new AbstractResourceLockRegistry.ResourceLockProducer<Path, TaskExecutionLock>(){

            @Override
            public TaskExecutionLock create(Path key, ResourceLockCoordinationService coordinationService, ResourceLockContainer owner) {
                return new TaskExecutionLock("task execution for " + projectIdentityPath.asString(), TaskExecutionLockRegistry.this.projectLockRegistry.getProjectLock(buildIdentityPath, projectIdentityPath1), coordinationService, owner);
            }
        });
    }

    private ResourceLock getTaskExecutionLockForBuild(final Path buildIdentityPath, final Path projectIdentityPath) {
        return this.getOrRegisterResourceLock(buildIdentityPath, new AbstractResourceLockRegistry.ResourceLockProducer<Path, TaskExecutionLock>(){

            @Override
            public TaskExecutionLock create(Path projectPath, ResourceLockCoordinationService coordinationService, ResourceLockContainer owner) {
                return new TaskExecutionLock("task execution for build " + buildIdentityPath.asString(), TaskExecutionLockRegistry.this.projectLockRegistry.getProjectLock(buildIdentityPath, projectIdentityPath), coordinationService, owner);
            }
        });
    }
}

