/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.compiler.java.listeners.constants;

import com.sun.source.util.JavacTask;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.compiler.java.listeners.constants.ConstantDependentsConsumer;
import org.gradle.internal.compiler.java.listeners.constants.ConstantsTreeVisitor;

public class ConstantsCollector
implements TaskListener {
    private final JavacTask task;
    private final Map<String, Collection<String>> mapping;
    private final ConstantDependentsConsumer constantDependentsConsumer;

    public ConstantsCollector(JavacTask task, ConstantDependentsConsumer constantDependentsConsumer) {
        this.task = task;
        this.mapping = new HashMap<String, Collection<String>>();
        this.constantDependentsConsumer = constantDependentsConsumer;
    }

    public Map<String, Collection<String>> getMapping() {
        return this.mapping;
    }

    @Override
    public void started(TaskEvent e) {
    }

    @Override
    public void finished(TaskEvent e) {
        if (e.getKind() == TaskEvent.Kind.ANALYZE) {
            Trees trees = Trees.instance(this.task);
            ConstantsTreeVisitor visitor = new ConstantsTreeVisitor(this.task.getElements(), trees, this.constantDependentsConsumer);
            TreePath path = trees.getPath(e.getCompilationUnit(), e.getCompilationUnit());
            visitor.scan(path, null);
        }
    }
}

