/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractCollectingSupplier;
import org.gradle.api.internal.provider.AbstractProperty;
import org.gradle.api.internal.provider.AppendOnceList;
import org.gradle.api.internal.provider.CollectionPropertyInternal;
import org.gradle.api.internal.provider.CollectionSupplier;
import org.gradle.api.internal.provider.Collector;
import org.gradle.api.internal.provider.Collectors;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValidatingValueCollector;
import org.gradle.api.internal.provider.ValueCollector;
import org.gradle.api.internal.provider.ValueSanitizers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.HasMultipleValues;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.evaluation.EvaluationScopeContext;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class AbstractCollectionProperty<T, C extends Collection<T>>
extends AbstractProperty<C, CollectionSupplier<T, C>>
implements CollectionPropertyInternal<T, C> {
    private final Class<? extends Collection> collectionType;
    private final Class<T> elementType;
    private final Supplier<ImmutableCollection.Builder<T>> collectionFactory;
    private final ValueCollector<T> valueCollector;
    private CollectionSupplier<T, C> defaultValue;

    AbstractCollectionProperty(PropertyHost host, Class<? extends Collection> collectionType, Class<T> elementType, Supplier<ImmutableCollection.Builder<T>> collectionFactory) {
        super(host);
        this.collectionType = collectionType;
        this.elementType = elementType;
        this.collectionFactory = collectionFactory;
        this.valueCollector = new ValidatingValueCollector<T>(collectionType, elementType, ValueSanitizers.forType(elementType));
        this.init();
    }

    private void init() {
        this.defaultValue = this.emptySupplier();
        this.init(this.defaultValue, this.noValueSupplier());
    }

    @Override
    protected CollectionSupplier<T, C> getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    protected CollectionSupplier<T, C> getDefaultConvention() {
        return this.noValueSupplier();
    }

    private CollectionSupplier<T, C> emptySupplier() {
        return new EmptySupplier();
    }

    private CollectionSupplier<T, C> noValueSupplier() {
        return new NoValueSupplier(ValueSupplier.Value.missing());
    }

    protected abstract C emptyCollection();

    private void withActualValue(Runnable action) {
        this.setToConventionIfUnset();
        action.run();
    }

    @Override
    protected boolean isDefaultConvention() {
        return this.isNoValueSupplier((CollectionSupplier)this.getConventionSupplier());
    }

    private boolean isNoValueSupplier(CollectionSupplier<T, C> valueSupplier) {
        return valueSupplier instanceof NoValueSupplier;
    }

    public void add(T element) {
        Preconditions.checkNotNull(element, (String)"Cannot add a null element to a property of type %s.", (Object)this.collectionType.getSimpleName());
        this.addExplicitCollector(new Collectors.SingleElement<T>(element));
    }

    public void add(Provider<? extends T> providerOfElement) {
        this.addExplicitCollector(new Collectors.ElementFromProvider<T>(Providers.internal(providerOfElement)));
    }

    @SafeVarargs
    public final void addAll(T ... elements) {
        this.addExplicitCollector(new Collectors.ElementsFromArray<T>(elements));
    }

    public void addAll(Iterable<? extends T> elements) {
        this.addExplicitCollector(new Collectors.ElementsFromCollection<T>(elements));
    }

    public void addAll(Provider<? extends Iterable<? extends T>> provider) {
        this.addExplicitCollector(new Collectors.ElementsFromCollectionProvider(Providers.internal(provider)));
    }

    @Override
    public void append(T element) {
        this.withActualValue(() -> this.add(element));
    }

    @Override
    public void append(Provider<? extends T> provider) {
        this.withActualValue(() -> this.add(provider));
    }

    @Override
    @SafeVarargs
    public final void appendAll(T ... elements) {
        this.withActualValue(() -> this.addAll(elements));
    }

    @Override
    public void appendAll(Iterable<? extends T> elements) {
        this.withActualValue(() -> this.addAll(elements));
    }

    @Override
    public void appendAll(Provider<? extends Iterable<? extends T>> provider) {
        this.withActualValue(() -> this.addAll(provider));
    }

    @Override
    public int size() {
        return ((Collection)this.calculateOwnPresentValue().getWithoutSideEffect()).size();
    }

    private void addExplicitCollector(Collector<T> collector) {
        this.assertCanMutate();
        this.setSupplier(this.withAppendedValue(collector));
    }

    private CollectionSupplier<T, C> withAppendedValue(Collector<T> value) {
        CollectionSupplier<T, C> currentValue = this.getExplicitValue(this.defaultValue);
        try {
            return currentValue.plus(value);
        }
        catch (IllegalStateException e) {
            throw this.failWithCorruptedStateException(e);
        }
    }

    @Override
    public @NonNull Class<C> getType() {
        return (Class)Cast.uncheckedNonnullCast(this.collectionType);
    }

    @Override
    public Class<T> getElementType() {
        return this.elementType;
    }

    public void fromState(ValueSupplier.ExecutionTimeValue<? extends C> value) {
        if (value.isMissing()) {
            this.setSupplier(this.noValueSupplier());
        } else if (value.hasFixedValue()) {
            this.setSupplier(new FixedSupplier(this, (Collection)value.getFixedValue(), (ValueSupplier.SideEffect)Cast.uncheckedCast(value.getSideEffect())));
        } else {
            CollectingSupplier asSupplier = (CollectingSupplier)Cast.uncheckedNonnullCast(value.getChangingValue());
            this.setSupplier(asSupplier);
        }
    }

    @Override
    public void setFromAnyValue(Object object) {
        if (object instanceof Provider) {
            this.set((Provider)Cast.uncheckedCast((Object)object));
        } else {
            if (object != null && !(object instanceof Iterable)) {
                throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using an instance of type %s.", this.collectionType.getName(), object.getClass().getName()));
            }
            this.set((Iterable)Cast.uncheckedCast((Object)object));
        }
    }

    public void set(@Nullable Iterable<? extends T> elements) {
        if (elements == null) {
            this.unsetValueAndDefault();
        } else {
            this.setSupplier(this.newSupplierOf(new Collectors.ElementsFromCollection<T>(elements)));
        }
    }

    public void set(Provider<? extends Iterable<? extends T>> provider) {
        CollectionPropertyInternal collectionProp;
        if (provider == null) {
            throw new IllegalArgumentException("Cannot set the value of a property using a null provider.");
        }
        ProviderInternal<Iterable<T>> p = Providers.internal(provider);
        if (p.getType() != null && !Iterable.class.isAssignableFrom(p.getType())) {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using a provider of type %s.", this.collectionType.getName(), p.getType().getName()));
        }
        if (p instanceof CollectionPropertyInternal && !this.elementType.isAssignableFrom((collectionProp = (CollectionPropertyInternal)Cast.uncheckedCast(p)).getElementType())) {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s with element type %s using a provider with element type %s.", this.collectionType.getName(), this.elementType.getName(), collectionProp.getElementType().getName()));
        }
        this.setSupplier(this.newSupplierOf(new Collectors.ElementsFromCollectionProvider(p)));
    }

    private void unsetValueAndDefault() {
        this.defaultValue = this.noValueSupplier();
        this.unset();
    }

    public HasMultipleValues<T> value(@Nullable Iterable<? extends T> elements) {
        this.set(elements);
        return this;
    }

    public HasMultipleValues<T> value(Provider<? extends Iterable<? extends T>> provider) {
        this.set(provider);
        return this;
    }

    public HasMultipleValues<T> empty() {
        this.setSupplier(this.emptySupplier());
        return this;
    }

    @Override
    protected ValueSupplier.Value<? extends C> calculateValueFrom(EvaluationScopeContext context, CollectionSupplier<T, C> value, ValueSupplier.ValueConsumer consumer) {
        return value.calculateValue(consumer);
    }

    @Override
    protected CollectionSupplier<T, C> finalValue(EvaluationScopeContext context, CollectionSupplier<T, C> value, ValueSupplier.ValueConsumer consumer) {
        ValueSupplier.Value<C> result = value.calculateValue(consumer);
        if (!result.isMissing()) {
            return new FixedSupplier(this, (Collection)result.getWithoutSideEffect(), (ValueSupplier.SideEffect)Cast.uncheckedCast(result.getSideEffect()));
        }
        if (result.getPathToOrigin().isEmpty()) {
            return this.noValueSupplier();
        }
        return new NoValueSupplier(result);
    }

    @Override
    protected ValueSupplier.ExecutionTimeValue<? extends C> calculateOwnExecutionTimeValue(EvaluationScopeContext context, CollectionSupplier<T, C> value) {
        return value.calculateExecutionTimeValue();
    }

    public HasMultipleValues<T> convention(@Nullable Iterable<? extends T> elements) {
        if (elements == null) {
            this.unsetConvention();
        } else {
            this.setConvention(this.newSupplierOf(new Collectors.ElementsFromCollection<T>(elements)));
        }
        return this;
    }

    public HasMultipleValues<T> convention(Provider<? extends Iterable<? extends T>> provider) {
        this.setConvention(this.newSupplierOf(new Collectors.ElementsFromCollectionProvider(Providers.internal(provider))));
        return this;
    }

    @Override
    protected String describeContents() {
        String typeDisplayName = this.collectionType.getSimpleName().toLowerCase(Locale.ROOT);
        return String.format("%s(%s, %s)", typeDisplayName, this.elementType, this.describeValue());
    }

    private CollectingSupplier<T, C> newSupplierOf(Collector<T> value) {
        return new CollectingSupplier<T, C>(this.getType(), this.collectionFactory, this.valueCollector, value);
    }

    public void replace(Transformer<? extends @Nullable Provider<? extends Iterable<? extends T>>, ? super Provider<C>> transformation) {
        Provider newValue = (Provider)transformation.transform(this.shallowCopy());
        if (newValue != null) {
            this.set(newValue);
        } else {
            this.set((Iterable)null);
        }
    }

    private static class CollectingSupplier<T, C extends Collection<T>>
    extends AbstractCollectingSupplier<Collector<T>, C>
    implements CollectionSupplier<T, C> {
        private final Class<C> type;
        private final Supplier<ImmutableCollection.Builder<T>> collectionFactory;
        private final ValueCollector<T> valueCollector;

        public CollectingSupplier(Class<C> type, Supplier<ImmutableCollection.Builder<T>> collectionFactory, ValueCollector<T> valueCollector, Collector<T> value) {
            this(type, collectionFactory, valueCollector, AppendOnceList.of(value));
        }

        private CollectingSupplier(Class<C> type, Supplier<ImmutableCollection.Builder<T>> collectionFactory, ValueCollector<T> valueCollector, AppendOnceList<Collector<T>> collectors) {
            super(collectors);
            this.type = type;
            this.collectionFactory = collectionFactory;
            this.valueCollector = valueCollector;
        }

        @Override
        public @Nullable Class<C> getType() {
            return this.type;
        }

        @Override
        public ValueSupplier.Value<? extends C> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
            return this.calculateValue((builder, collector) -> collector.collectEntries(consumer, this.valueCollector, builder), this.collectionFactory.get(), builder -> (Collection)Cast.uncheckedNonnullCast((Object)builder.build()));
        }

        @Override
        public CollectionSupplier<T, C> plus(Collector<T> addedCollector) {
            return new CollectingSupplier<T, C>(this.type, this.collectionFactory, this.valueCollector, this.collectors.plus(addedCollector));
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends C> calculateExecutionTimeValue() {
            return this.calculateExecutionTimeValue(collector -> collector.calculateExecutionTimeValue(), this::calculateFixedExecutionTimeValue, this::calculateChangingExecutionTimeValue);
        }

        private ValueSupplier.ExecutionTimeValue<? extends C> calculateChangingExecutionTimeValue(List<ValueSupplier.ExecutionTimeValue<? extends C>> values) {
            return ValueSupplier.ExecutionTimeValue.changingValue(new CollectingSupplier<T, C>(this.type, this.collectionFactory, this.valueCollector, values.stream().map(this::toCollector).collect(AppendOnceList.toAppendOnceList())));
        }

        private ValueSupplier.ExecutionTimeValue<? extends C> calculateFixedExecutionTimeValue(List<ValueSupplier.ExecutionTimeValue<? extends C>> executionTimeValues, ValueSupplier.SideEffectBuilder<C> sideEffectBuilder) {
            ImmutableCollection.Builder<T> entries = this.collectionFactory.get();
            for (ValueSupplier.ExecutionTimeValue<C> value : executionTimeValues) {
                this.valueCollector.addAll((Iterable)value.getFixedValue(), entries);
                sideEffectBuilder.add(ValueSupplier.SideEffect.fixedFrom(value));
            }
            return ValueSupplier.ExecutionTimeValue.fixedValue((Collection)Cast.uncheckedNonnullCast((Object)entries.build()));
        }

        private Collector<T> toCollector(ValueSupplier.ExecutionTimeValue<? extends Iterable<? extends T>> value) {
            Preconditions.checkArgument((!value.isMissing() ? 1 : 0) != 0, (Object)"Cannot get a collector for the missing value");
            if (value.isChangingValue() || value.hasChangingContent() || value.getSideEffect() != null) {
                return new Collectors.ElementsFromCollectionProvider(value.toProvider());
            }
            return new Collectors.ElementsFromCollection<T>(value.getFixedValue());
        }
    }

    private class EmptySupplier
    implements CollectionSupplier<T, C> {
        private EmptySupplier() {
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        @Override
        public ValueSupplier.Value<? extends C> calculateValue(ValueSupplier.ValueConsumer consumer) {
            return ValueSupplier.Value.of(AbstractCollectionProperty.this.emptyCollection());
        }

        @Override
        public CollectionSupplier<T, C> plus(Collector<T> collector) {
            return AbstractCollectionProperty.this.newSupplierOf(collector);
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends C> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.fixedValue(AbstractCollectionProperty.this.emptyCollection());
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.noProducer();
        }

        public String toString() {
            return "[]";
        }
    }

    class NoValueSupplier
    implements CollectionSupplier<T, C> {
        private final ValueSupplier.Value<? extends C> value;

        public NoValueSupplier(ValueSupplier.Value<? extends C> value) {
            assert (value.isMissing());
            this.value = value.asType();
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return false;
        }

        @Override
        public ValueSupplier.Value<? extends C> calculateValue(ValueSupplier.ValueConsumer consumer) {
            return this.value;
        }

        @Override
        public CollectionSupplier<T, C> plus(Collector<T> collector) {
            return this;
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends C> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.missing();
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private static class FixedSupplier
    implements CollectionSupplier<T, C> {
        private final C value;
        private final ValueSupplier.SideEffect<? super C> sideEffect;
        final /* synthetic */ AbstractCollectionProperty this$0;

        public FixedSupplier(@Nullable C value, ValueSupplier.SideEffect<? super C> sideEffect) {
            this.this$0 = var1_1;
            this.value = value;
            this.sideEffect = sideEffect;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        @Override
        public ValueSupplier.Value<? extends C> calculateValue(ValueSupplier.ValueConsumer consumer) {
            return ValueSupplier.Value.of(this.value).withSideEffect(this.sideEffect);
        }

        @Override
        public CollectionSupplier<T, C> plus(Collector<T> collector) {
            return this.this$0.newSupplierOf(new FixedValueCollector((Collection)this.value, this.sideEffect, null)).plus(collector);
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends C> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.fixedValue(this.value).withSideEffect(this.sideEffect);
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private static class FixedValueCollector<T, C extends Collection<T>>
    implements Collector<T> {
        private final  @Nullable ValueSupplier.SideEffect<? super C> sideEffect;
        private final C collection;

        private FixedValueCollector(C collection,  @Nullable ValueSupplier.SideEffect<? super C> sideEffect) {
            this.collection = collection;
            this.sideEffect = sideEffect;
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, ValueCollector<T> collector, ImmutableCollection.Builder<T> dest) {
            collector.addAll((Iterable<T>)this.collection, dest);
            return this.sideEffect != null ? ValueSupplier.Value.present().withSideEffect(ValueSupplier.SideEffect.fixed(this.collection, this.sideEffect)) : ValueSupplier.Value.present();
        }

        @Override
        public int size() {
            return this.collection.size();
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Iterable<? extends T>> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.fixedValue(this.collection).withSideEffect(this.sideEffect);
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        public String toString() {
            return this.collection.toString();
        }

        /* synthetic */ FixedValueCollector(Collection x0, ValueSupplier.SideEffect x1, 1 x2) {
            this(x0, x1);
        }
    }
}

