/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.configurator;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.event.RowSorterEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.plugin.codeexplorer.configurator.CellRendererWithTooltip;
import org.freeplane.plugin.codeexplorer.dependencies.CodeDependency;
import org.freeplane.plugin.codeexplorer.map.CodeMap;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.map.SelectedNodeDependencies;
import org.freeplane.plugin.codeexplorer.task.GroupMatcher;

class CodeDependenciesPanel
extends JPanel
implements INodeSelectionListener,
IMapSelectionListener,
IFreeplanePropertyListener,
IMapChangeListener {
    private static final String[] COLUMN_NAMES = new String[]{"Verdict", "Origin", "Target", "Dependency"};
    private static final long serialVersionUID = 1L;
    private final JTextField filterField;
    private final JTable dependencyViewer;
    private final JLabel countLabel;
    private final List<Consumer<Object>> dependencySelectionCallbacks;
    private List<CodeDependency> allDependencies;
    private boolean isLastColumnVisible = true;
    private AFreeplaneAction filterAction;

    CodeDependenciesPanel(AFreeplaneAction filterAction) {
        this.filterAction = filterAction;
        this.dependencySelectionCallbacks = new ArrayList<Consumer<Object>>();
        JPanel topPanel = new JPanel(new BorderLayout());
        JButton filterButton = TranslatedElementFactory.createButtonWithIcon((AFreeplaneAction)filterAction);
        filterButton.setEnabled(false);
        this.countLabel = new JLabel();
        int countLabelMargin = (int)(UITools.FONT_SCALE_FACTOR * 10.0f);
        Box filterBox = Box.createHorizontalBox();
        filterBox.add(filterButton);
        filterBox.add(Box.createHorizontalStrut(countLabelMargin));
        filterBox.add(this.countLabel);
        filterBox.add(Box.createHorizontalStrut(countLabelMargin));
        topPanel.add((Component)filterBox, "West");
        this.filterField = new JTextField();
        this.filterField.addActionListener(e -> this.updateDependencyFilter());
        topPanel.add((Component)this.filterField, "Center");
        JCheckBox toggleLastColumnButton = TranslatedElementFactory.createCheckBox((String)"code.toggle_dependencies");
        toggleLastColumnButton.setSelected(this.isLastColumnVisible);
        toggleLastColumnButton.addActionListener(e -> this.toggleLastColumnVisibility());
        topPanel.add((Component)toggleLastColumnButton, "East");
        this.dependencyViewer = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                JComponent component = (JComponent)super.prepareRenderer(renderer, row, column);
                int modelColumn = this.convertColumnIndexToModel(column);
                if (modelColumn == 1 || modelColumn == 2) {
                    CodeDependency codeDependency = (CodeDependency)CodeDependenciesPanel.this.allDependencies.get(this.convertRowIndexToModel(row));
                    JavaClass javaClass = modelColumn == 1 ? codeDependency.getOriginClass() : codeDependency.getTargetClass();
                    component.setToolTipText(CodeDependenciesPanel.this.toDisplayedFullName(javaClass));
                }
                return component;
            }
        };
        this.allDependencies = Collections.emptyList();
        DependenciesWrapper dataModel = new DependenciesWrapper();
        this.dependencyViewer.setModel(dataModel);
        CellRendererWithTooltip cellRenderer = new CellRendererWithTooltip();
        TableColumnModel columnModel = this.dependencyViewer.getColumnModel();
        this.updateColumn(columnModel, 0, 80, cellRenderer);
        this.updateColumn(columnModel, 1, 200, cellRenderer);
        this.updateColumn(columnModel, 2, 200, cellRenderer);
        this.updateColumn(columnModel, 3, 1200, cellRenderer);
        this.dependencyViewer.getSelectionModel().setSelectionMode(2);
        this.dependencyViewer.getColumnModel().getSelectionModel().setSelectionMode(1);
        this.dependencyViewer.setCellSelectionEnabled(true);
        TableRowSorter<DependenciesWrapper> sorter = new TableRowSorter<DependenciesWrapper>(dataModel);
        sorter.addRowSorterListener(e -> {
            if (e.getType() == RowSorterEvent.Type.SORT_ORDER_CHANGED) {
                SwingUtilities.invokeLater(this::scrollSelectedToVisible);
            }
        });
        this.dependencyViewer.setRowSorter(sorter);
        JTextField cellEditor = new JTextField();
        cellEditor.setEditable(false);
        this.dependencyViewer.setDefaultEditor(Object.class, new DefaultCellEditor(cellEditor));
        JScrollPane scrollPane = new JScrollPane(this.dependencyViewer);
        this.setLayout(new BorderLayout());
        this.add((Component)topPanel, "North");
        this.add((Component)scrollPane, "Center");
    }

    private void updateDependencyFilter() {
        final String[] filteredWords = this.filterField.getText().trim().split("[^\\w:.$]+");
        TableRowSorter rowSorter = (TableRowSorter)this.dependencyViewer.getRowSorter();
        RowFilter<DependenciesWrapper, Integer> textFilter = null;
        if (filteredWords.length != 1 || !filteredWords[0].isEmpty()) {
            textFilter = new RowFilter<DependenciesWrapper, Integer>(){
                BiPredicate<CodeDependency, String[]> combinedFilter;
                {
                    this.combinedFilter = Stream.of(filteredWords).map(this::createPredicateFromString).reduce((x, y) -> true, BiPredicate::and);
                }

                private BiPredicate<CodeDependency, String[]> createPredicateFromString(String searchedString) {
                    if (searchedString.startsWith("origin:")) {
                        String value = searchedString.substring("origin:".length());
                        return (dependency, row) -> dependency.getOriginClass().getName().contains(value);
                    }
                    if (searchedString.startsWith("target:")) {
                        String value = searchedString.substring("target:".length());
                        return (dependency, row) -> dependency.getTargetClass().getName().contains(value);
                    }
                    if (searchedString.startsWith("verdict:")) {
                        String value = searchedString.substring("verdict:".length());
                        return (dependency, row) -> row[0].contains(value);
                    }
                    if (searchedString.startsWith("dependency:")) {
                        String value = searchedString.substring("dependency:".length());
                        return (dependency, row) -> row[3].contains(value);
                    }
                    if (searchedString.equalsIgnoreCase(":rmi")) {
                        return this::isRmiDependency;
                    }
                    return (dependency, row) -> Stream.of(row).anyMatch(s -> s.contains(searchedString));
                }

                private boolean isRmiDependency(CodeDependency codeDependency, String[] row) {
                    MapModel map = Controller.getCurrentController().getSelection().getMap();
                    if (!(map instanceof CodeMap)) {
                        return false;
                    }
                    CodeMap codeMap = (CodeMap)map;
                    if (codeMap.matchingCriteria(codeDependency.getOriginClass(), codeDependency.getTargetClass()).filter(GroupMatcher.MatchingCriteria.RMI::equals).isPresent()) {
                        return row[3].contains(" implements ") || row[3].contains(" extends ") || row[3].contains(" constructor ");
                    }
                    return false;
                }

                @Override
                public boolean include(RowFilter.Entry<? extends DependenciesWrapper, ? extends Integer> entry) {
                    TableModel tableData = CodeDependenciesPanel.this.dependencyViewer.getModel();
                    int rowIndex = entry.getIdentifier();
                    String[] row = (String[])IntStream.range(0, 4).mapToObj(column -> tableData.getValueAt(rowIndex, column).toString()).toArray(String[]::new);
                    return this.combinedFilter.test((CodeDependency)CodeDependenciesPanel.this.allDependencies.get(rowIndex), row);
                }
            };
        }
        RowFilter<DependenciesWrapper, Integer> uniqueRowFilter = null;
        if (!this.isLastColumnVisible) {
            uniqueRowFilter = new RowFilter<DependenciesWrapper, Integer>(){
                private final Set<String> visibleRowSignatures = new HashSet<String>();

                @Override
                public boolean include(RowFilter.Entry<? extends DependenciesWrapper, ? extends Integer> entry) {
                    StringBuilder signature = new StringBuilder();
                    for (int i = 1; i < 3; ++i) {
                        signature.append(entry.getModel().getValueAt(entry.getIdentifier(), i));
                        signature.append("||");
                    }
                    return this.visibleRowSignatures.add(signature.toString());
                }
            };
        }
        if (textFilter != null && uniqueRowFilter != null) {
            rowSorter.setRowFilter(RowFilter.andFilter(Arrays.asList(textFilter, uniqueRowFilter)));
        } else if (textFilter != null) {
            rowSorter.setRowFilter(textFilter);
        } else if (uniqueRowFilter != null) {
            rowSorter.setRowFilter(uniqueRowFilter);
        } else {
            rowSorter.setRowFilter(null);
        }
        this.dependencySelectionCallbacks.stream().forEach(x -> x.accept(this));
        this.scrollSelectedToVisible();
        this.updateRowCountLabelAndFilterAction();
    }

    private void updateColumn(TableColumnModel columns, int index, int columnWidth, TableCellRenderer cellRenderer) {
        int scaledWidth = (int)((float)columnWidth * UITools.FONT_SCALE_FACTOR);
        TableColumn columnModel = columns.getColumn(index);
        columnModel.setWidth(scaledWidth);
        columnModel.setPreferredWidth(scaledWidth);
        columnModel.setCellRenderer(cellRenderer);
    }

    public void afterMapChange(MapModel oldMap, MapModel newMap) {
        this.update();
    }

    void update() {
        Controller controller = Controller.getCurrentController();
        this.update(controller.getSelection());
    }

    public void onSelectionSetChange(IMapSelection selection) {
        this.update(selection);
    }

    public void mapChanged(MapChangeEvent event) {
        if (event.getProperty().equals(Filter.class)) {
            SwingUtilities.invokeLater(this::update);
        }
    }

    private void update(IMapSelection selection) {
        Set selectedDependencies = this.getSelectedCodeDependencies().collect(Collectors.toSet());
        int selectedColumn = this.dependencyViewer.getSelectedColumn();
        this.allDependencies = Collections.emptyList();
        ((DependenciesWrapper)this.dependencyViewer.getModel()).fireTableDataChanged();
        if (selection != null && selection.getMap() instanceof CodeMap) {
            this.allDependencies = this.selectedDependencies(new SelectedNodeDependencies(selection));
            this.updateDependencyFilter();
        } else {
            TableRowSorter rowSorter = (TableRowSorter)this.dependencyViewer.getRowSorter();
            rowSorter.setRowFilter(null);
            this.updateRowCountLabelAndFilterAction();
        }
        if (!selectedDependencies.isEmpty()) {
            IntStream.range(0, this.allDependencies.size()).filter(i -> selectedDependencies.contains(this.allDependencies.get(i))).map(this.dependencyViewer::convertRowIndexToView).forEach(row -> this.dependencyViewer.addRowSelectionInterval(row, row));
            if (this.dependencyViewer.getSelectedRow() != -1) {
                this.dependencyViewer.setColumnSelectionInterval(selectedColumn, selectedColumn);
                SwingUtilities.invokeLater(this::scrollSelectedToVisible);
            }
        }
        if (this.isShowing()) {
            this.dependencySelectionCallbacks.stream().forEach(x -> x.accept(this));
        }
    }

    private List<CodeDependency> selectedDependencies(SelectedNodeDependencies selectedNodeDependencies) {
        return selectedNodeDependencies.getSelectedDependencies().map(selectedNodeDependencies.getMap()::toCodeDependency).collect(Collectors.toCollection(ArrayList::new));
    }

    private Stream<CodeDependency> getSelectedCodeDependencies() {
        return IntStream.of(this.dependencyViewer.getSelectedRows()).map(this.dependencyViewer::convertRowIndexToModel).mapToObj(this.allDependencies::get);
    }

    private Set<Dependency> getSelectedDependencies() {
        return this.getSelectedCodeDependencies().map(CodeDependency::getDependency).collect(Collectors.toSet());
    }

    public Set<Dependency> getFilteredDependencies() {
        Set<Dependency> selectedDependencies = this.getSelectedDependencies();
        if (!selectedDependencies.isEmpty()) {
            return selectedDependencies;
        }
        if (this.dependencyViewer.getRowCount() < this.allDependencies.size()) {
            return this.getVisibleDependencies();
        }
        return Collections.emptySet();
    }

    public Set<JavaClass> getSelectedClasses() {
        return this.getFilteredDependencies().stream().flatMap(d -> Stream.of(d.getOriginClass(), d.getTargetClass())).collect(Collectors.toSet());
    }

    private Set<Dependency> getVisibleDependencies() {
        return IntStream.range(0, this.dependencyViewer.getRowCount()).map(this.dependencyViewer::convertRowIndexToModel).mapToObj(this.allDependencies::get).map(CodeDependency::getDependency).collect(Collectors.toSet());
    }

    private void updateRowCountLabelAndFilterAction() {
        int dependencyCount;
        int rowCount = this.dependencyViewer.getRowCount();
        if (!this.isLastColumnVisible) {
            HashSet<String> uniqueSignatures = new HashSet<String>();
            for (CodeDependency dependency : this.allDependencies) {
                StringBuilder signature = new StringBuilder();
                signature.append(this.toDisplayedFullName(dependency.getOriginClass())).append("||").append(this.toDisplayedFullName(dependency.getTargetClass()));
                uniqueSignatures.add(signature.toString());
            }
            dependencyCount = uniqueSignatures.size();
        } else {
            dependencyCount = this.allDependencies.size();
        }
        this.countLabel.setText("( " + rowCount + " / " + dependencyCount + " )");
        this.enableFilterAction();
    }

    private void enableFilterAction() {
        int rowCount = this.dependencyViewer.getRowCount();
        int dependencyCount = this.allDependencies.size();
        int selectedRowCount = this.dependencyViewer.getSelectedRowCount();
        this.filterAction.setEnabled(rowCount > 0 && rowCount < dependencyCount || selectedRowCount > 0 && selectedRowCount < dependencyCount);
    }

    private void scrollSelectedToVisible() {
        int selectedRowOnView = this.dependencyViewer.getSelectedRow();
        if (selectedRowOnView != -1) {
            this.dependencyViewer.scrollRectToVisible(new Rectangle(this.dependencyViewer.getCellRect(selectedRowOnView, 0, true)));
        }
    }

    public void propertyChanged(String propertyName, String newValue, String oldValue) {
        if (propertyName.equals("code_showOutsideDependencies")) {
            Controller controller = Controller.getCurrentController();
            IMapSelection selection = controller.getSelection();
            this.update(selection);
            controller.getMapViewManager().getMapViewComponent().repaint();
        }
    }

    void addDependencySelectionCallback(final Consumer<Object> listener) {
        this.dependencyViewer.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                listener.accept(this);
                this.enableFilterAction();
            }
        });
        this.dependencyViewer.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!e.isTemporary()) {
                    listener.accept(this);
                }
            }
        });
        this.dependencySelectionCallbacks.add(listener);
    }

    private String toDisplayedFullName(JavaClass originClass) {
        return CodeNode.findEnclosingNamedClass(originClass).getName().replace('$', '.');
    }

    private void toggleLastColumnVisibility() {
        if (this.isLastColumnVisible) {
            this.hideLastColumn();
        } else {
            this.showLastColumn();
        }
        this.isLastColumnVisible = !this.isLastColumnVisible;
        this.updateDependencyFilter();
    }

    private void hideLastColumn() {
        TableColumnModel columnModel = this.dependencyViewer.getColumnModel();
        if (columnModel.getColumnCount() > 3) {
            TableColumn column = columnModel.getColumn(3);
            columnModel.removeColumn(column);
        }
    }

    private void showLastColumn() {
        TableColumnModel columnModel = this.dependencyViewer.getColumnModel();
        if (columnModel.getColumnCount() == 3) {
            TableColumn column = new TableColumn(3);
            column.setHeaderValue(COLUMN_NAMES[3]);
            columnModel.addColumn(column);
            this.updateColumn(columnModel, 3, 1200, new CellRendererWithTooltip());
        }
    }

    private class DependenciesWrapper
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private DependenciesWrapper() {
        }

        @Override
        public int getRowCount() {
            return CodeDependenciesPanel.this.allDependencies.size();
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            CodeDependency row = (CodeDependency)CodeDependenciesPanel.this.allDependencies.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return row.describeVerdict();
                }
                case 1: {
                    String originName = CodeDependenciesPanel.this.toDisplayedFullName(row.getOriginClass());
                    String targetName = CodeDependenciesPanel.this.toDisplayedFullName(row.getTargetClass());
                    return this.shortenClassNameIfCommonPrefix(originName, targetName);
                }
                case 2: {
                    String originName = CodeDependenciesPanel.this.toDisplayedFullName(row.getOriginClass());
                    String targetName = CodeDependenciesPanel.this.toDisplayedFullName(row.getTargetClass());
                    return this.shortenClassNameIfCommonPrefix(targetName, originName);
                }
                case 3: {
                    return row.getDescription();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            return COLUMN_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0;
        }

        private String shortenClassNameIfCommonPrefix(String name, String otherName) {
            String[] nameParts = name.split("\\.");
            String[] otherParts = otherName.split("\\.");
            int commonPrefixCount = 0;
            int minLength = Math.min(nameParts.length, otherParts.length);
            for (int i = 0; i < minLength - 1 && nameParts[i].equals(otherParts[i]); ++i) {
                ++commonPrefixCount;
            }
            if (commonPrefixCount > 0) {
                StringBuilder shortened = new StringBuilder("..");
                for (int i = commonPrefixCount; i < nameParts.length; ++i) {
                    shortened.append(".").append(nameParts[i]);
                }
                return shortened.toString();
            }
            return name;
        }
    }
}

