﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/redshift/Redshift_EXPORTS.h>
#include <aws/redshift/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace Redshift {
namespace Model {
/**
 * <p/><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ClusterParameterGroupNameMessage">AWS
 * API Reference</a></p>
 */
class ResetClusterParameterGroupResult {
 public:
  AWS_REDSHIFT_API ResetClusterParameterGroupResult() = default;
  AWS_REDSHIFT_API ResetClusterParameterGroupResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_REDSHIFT_API ResetClusterParameterGroupResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The name of the cluster parameter group.</p>
   */
  inline const Aws::String& GetParameterGroupName() const { return m_parameterGroupName; }
  template <typename ParameterGroupNameT = Aws::String>
  void SetParameterGroupName(ParameterGroupNameT&& value) {
    m_parameterGroupNameHasBeenSet = true;
    m_parameterGroupName = std::forward<ParameterGroupNameT>(value);
  }
  template <typename ParameterGroupNameT = Aws::String>
  ResetClusterParameterGroupResult& WithParameterGroupName(ParameterGroupNameT&& value) {
    SetParameterGroupName(std::forward<ParameterGroupNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the parameter group. For example, if you made a change to a
   * parameter group name-value pair, then the change could be pending a reboot of an
   * associated cluster.</p>
   */
  inline const Aws::String& GetParameterGroupStatus() const { return m_parameterGroupStatus; }
  template <typename ParameterGroupStatusT = Aws::String>
  void SetParameterGroupStatus(ParameterGroupStatusT&& value) {
    m_parameterGroupStatusHasBeenSet = true;
    m_parameterGroupStatus = std::forward<ParameterGroupStatusT>(value);
  }
  template <typename ParameterGroupStatusT = Aws::String>
  ResetClusterParameterGroupResult& WithParameterGroupStatus(ParameterGroupStatusT&& value) {
    SetParameterGroupStatus(std::forward<ParameterGroupStatusT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  ResetClusterParameterGroupResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_parameterGroupName;
  bool m_parameterGroupNameHasBeenSet = false;

  Aws::String m_parameterGroupStatus;
  bool m_parameterGroupStatusHasBeenSet = false;

  ResponseMetadata m_responseMetadata;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace Redshift
}  // namespace Aws
