﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/medialive/MediaLive_EXPORTS.h>
#include <aws/medialive/model/MultiplexSettingsSummary.h>
#include <aws/medialive/model/MultiplexState.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace MediaLive {
namespace Model {

/**
 * Placeholder documentation for MultiplexSummary<p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/MultiplexSummary">AWS
 * API Reference</a></p>
 */
class MultiplexSummary {
 public:
  AWS_MEDIALIVE_API MultiplexSummary() = default;
  AWS_MEDIALIVE_API MultiplexSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEDIALIVE_API MultiplexSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEDIALIVE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * The unique arn of the multiplex.
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  MultiplexSummary& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * A list of availability zones for the multiplex.
   */
  inline const Aws::Vector<Aws::String>& GetAvailabilityZones() const { return m_availabilityZones; }
  inline bool AvailabilityZonesHasBeenSet() const { return m_availabilityZonesHasBeenSet; }
  template <typename AvailabilityZonesT = Aws::Vector<Aws::String>>
  void SetAvailabilityZones(AvailabilityZonesT&& value) {
    m_availabilityZonesHasBeenSet = true;
    m_availabilityZones = std::forward<AvailabilityZonesT>(value);
  }
  template <typename AvailabilityZonesT = Aws::Vector<Aws::String>>
  MultiplexSummary& WithAvailabilityZones(AvailabilityZonesT&& value) {
    SetAvailabilityZones(std::forward<AvailabilityZonesT>(value));
    return *this;
  }
  template <typename AvailabilityZonesT = Aws::String>
  MultiplexSummary& AddAvailabilityZones(AvailabilityZonesT&& value) {
    m_availabilityZonesHasBeenSet = true;
    m_availabilityZones.emplace_back(std::forward<AvailabilityZonesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The unique id of the multiplex.
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  MultiplexSummary& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * Configuration for a multiplex event.
   */
  inline const MultiplexSettingsSummary& GetMultiplexSettings() const { return m_multiplexSettings; }
  inline bool MultiplexSettingsHasBeenSet() const { return m_multiplexSettingsHasBeenSet; }
  template <typename MultiplexSettingsT = MultiplexSettingsSummary>
  void SetMultiplexSettings(MultiplexSettingsT&& value) {
    m_multiplexSettingsHasBeenSet = true;
    m_multiplexSettings = std::forward<MultiplexSettingsT>(value);
  }
  template <typename MultiplexSettingsT = MultiplexSettingsSummary>
  MultiplexSummary& WithMultiplexSettings(MultiplexSettingsT&& value) {
    SetMultiplexSettings(std::forward<MultiplexSettingsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The name of the multiplex.
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  MultiplexSummary& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The number of currently healthy pipelines.
   */
  inline int GetPipelinesRunningCount() const { return m_pipelinesRunningCount; }
  inline bool PipelinesRunningCountHasBeenSet() const { return m_pipelinesRunningCountHasBeenSet; }
  inline void SetPipelinesRunningCount(int value) {
    m_pipelinesRunningCountHasBeenSet = true;
    m_pipelinesRunningCount = value;
  }
  inline MultiplexSummary& WithPipelinesRunningCount(int value) {
    SetPipelinesRunningCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * The number of programs in the multiplex.
   */
  inline int GetProgramCount() const { return m_programCount; }
  inline bool ProgramCountHasBeenSet() const { return m_programCountHasBeenSet; }
  inline void SetProgramCount(int value) {
    m_programCountHasBeenSet = true;
    m_programCount = value;
  }
  inline MultiplexSummary& WithProgramCount(int value) {
    SetProgramCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * The current state of the multiplex.
   */
  inline MultiplexState GetState() const { return m_state; }
  inline bool StateHasBeenSet() const { return m_stateHasBeenSet; }
  inline void SetState(MultiplexState value) {
    m_stateHasBeenSet = true;
    m_state = value;
  }
  inline MultiplexSummary& WithState(MultiplexState value) {
    SetState(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * A collection of key-value pairs.
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  MultiplexSummary& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  MultiplexSummary& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;
  bool m_arnHasBeenSet = false;

  Aws::Vector<Aws::String> m_availabilityZones;
  bool m_availabilityZonesHasBeenSet = false;

  Aws::String m_id;
  bool m_idHasBeenSet = false;

  MultiplexSettingsSummary m_multiplexSettings;
  bool m_multiplexSettingsHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  int m_pipelinesRunningCount{0};
  bool m_pipelinesRunningCountHasBeenSet = false;

  int m_programCount{0};
  bool m_programCountHasBeenSet = false;

  MultiplexState m_state{MultiplexState::NOT_SET};
  bool m_stateHasBeenSet = false;

  Aws::Map<Aws::String, Aws::String> m_tags;
  bool m_tagsHasBeenSet = false;
};

}  // namespace Model
}  // namespace MediaLive
}  // namespace Aws
