﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/greengrassv2/GreengrassV2_EXPORTS.h>
#include <aws/greengrassv2/model/ComponentPlatform.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace GreengrassV2 {
namespace Model {

/**
 * <p>Contains information about the latest version of a component.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ComponentLatestVersion">AWS
 * API Reference</a></p>
 */
class ComponentLatestVersion {
 public:
  AWS_GREENGRASSV2_API ComponentLatestVersion() = default;
  AWS_GREENGRASSV2_API ComponentLatestVersion(Aws::Utils::Json::JsonView jsonValue);
  AWS_GREENGRASSV2_API ComponentLatestVersion& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GREENGRASSV2_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The <a
   * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a>
   * of the component version.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  ComponentLatestVersion& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version of the component.</p>
   */
  inline const Aws::String& GetComponentVersion() const { return m_componentVersion; }
  inline bool ComponentVersionHasBeenSet() const { return m_componentVersionHasBeenSet; }
  template <typename ComponentVersionT = Aws::String>
  void SetComponentVersion(ComponentVersionT&& value) {
    m_componentVersionHasBeenSet = true;
    m_componentVersion = std::forward<ComponentVersionT>(value);
  }
  template <typename ComponentVersionT = Aws::String>
  ComponentLatestVersion& WithComponentVersion(ComponentVersionT&& value) {
    SetComponentVersion(std::forward<ComponentVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time at which the component was created, expressed in ISO 8601
   * format.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTimestamp() const { return m_creationTimestamp; }
  inline bool CreationTimestampHasBeenSet() const { return m_creationTimestampHasBeenSet; }
  template <typename CreationTimestampT = Aws::Utils::DateTime>
  void SetCreationTimestamp(CreationTimestampT&& value) {
    m_creationTimestampHasBeenSet = true;
    m_creationTimestamp = std::forward<CreationTimestampT>(value);
  }
  template <typename CreationTimestampT = Aws::Utils::DateTime>
  ComponentLatestVersion& WithCreationTimestamp(CreationTimestampT&& value) {
    SetCreationTimestamp(std::forward<CreationTimestampT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the component version.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  ComponentLatestVersion& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The publisher of the component version.</p>
   */
  inline const Aws::String& GetPublisher() const { return m_publisher; }
  inline bool PublisherHasBeenSet() const { return m_publisherHasBeenSet; }
  template <typename PublisherT = Aws::String>
  void SetPublisher(PublisherT&& value) {
    m_publisherHasBeenSet = true;
    m_publisher = std::forward<PublisherT>(value);
  }
  template <typename PublisherT = Aws::String>
  ComponentLatestVersion& WithPublisher(PublisherT&& value) {
    SetPublisher(std::forward<PublisherT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The platforms that the component version supports.</p>
   */
  inline const Aws::Vector<ComponentPlatform>& GetPlatforms() const { return m_platforms; }
  inline bool PlatformsHasBeenSet() const { return m_platformsHasBeenSet; }
  template <typename PlatformsT = Aws::Vector<ComponentPlatform>>
  void SetPlatforms(PlatformsT&& value) {
    m_platformsHasBeenSet = true;
    m_platforms = std::forward<PlatformsT>(value);
  }
  template <typename PlatformsT = Aws::Vector<ComponentPlatform>>
  ComponentLatestVersion& WithPlatforms(PlatformsT&& value) {
    SetPlatforms(std::forward<PlatformsT>(value));
    return *this;
  }
  template <typename PlatformsT = ComponentPlatform>
  ComponentLatestVersion& AddPlatforms(PlatformsT&& value) {
    m_platformsHasBeenSet = true;
    m_platforms.emplace_back(std::forward<PlatformsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;
  bool m_arnHasBeenSet = false;

  Aws::String m_componentVersion;
  bool m_componentVersionHasBeenSet = false;

  Aws::Utils::DateTime m_creationTimestamp{};
  bool m_creationTimestampHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  Aws::String m_publisher;
  bool m_publisherHasBeenSet = false;

  Aws::Vector<ComponentPlatform> m_platforms;
  bool m_platformsHasBeenSet = false;
};

}  // namespace Model
}  // namespace GreengrassV2
}  // namespace Aws
