/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing;

import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.util.CharArrayUtils;

public class LabelFormatterImpl
implements LabelFormatter {
    private final String delimiter;

    public LabelFormatterImpl(String termDelimiter) {
        this.delimiter = termDelimiter;
    }

    @Override
    public String format(char[][] image, boolean[] stopWord) {
        StringBuilder label = new StringBuilder();
        for (int i = 0; i < image.length; ++i) {
            if (i > 0) {
                label.append(this.delimiter);
            }
            LabelFormatterImpl.append(label, image[i], stopWord[i]);
        }
        return label.toString();
    }

    private static void append(StringBuilder label, char[] image, boolean stopword) {
        if (CharArrayUtils.hasCapitalizedLetters(image)) {
            label.append(image);
        } else if (label.length() == 0 || !stopword) {
            label.append(CharArrayUtils.toCapitalizedCopy(image));
        } else {
            label.append(CharArrayUtils.toLowerCaseCopy(image));
        }
    }
}

