/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.index;

import java.util.Set;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.misc.index.BPIndexReorderer;
import org.apache.lucene.misc.index.BPReorderingMergePolicy;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.index.MergePolicyFactoryArgs;
import org.apache.solr.index.WrapperMergePolicyFactory;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.util.SolrPluginUtils;

public class BPReorderingMergePolicyFactory
extends WrapperMergePolicyFactory {
    private static final String BPR_PREFIX = "bpr.prefix";
    private final BPIndexReorderer reorderer = new BPIndexReorderer();

    public BPReorderingMergePolicyFactory(SolrResourceLoader resourceLoader, MergePolicyFactoryArgs args, IndexSchema schema) {
        super(resourceLoader, args, schema);
        MergePolicyFactoryArgs bprArgs = this.filterWrappedMergePolicyFactoryArgs(BPR_PREFIX);
        if (bprArgs != null) {
            String fields = (String)bprArgs.remove("fields");
            if (fields != null) {
                this.reorderer.setFields(Set.of(fields.split(",")));
            }
            SolrPluginUtils.invokeSetters(this.reorderer, bprArgs.args.entrySet());
        }
    }

    @Override
    protected MergePolicy getMergePolicyInstance(MergePolicy wrappedMP) {
        BPReorderingMergePolicy mp = new BPReorderingMergePolicy(wrappedMP, this.reorderer);
        return mp;
    }
}

