/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkShardTerms;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.util.TestInjection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PrepRecoveryOp
implements CoreAdminHandler.CoreAdminOp {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    PrepRecoveryOp() {
    }

    @Override
    public void execute(CoreAdminHandler.CallInfo it) throws Exception {
        CloudDescriptor cloudDescriptor;
        String collectionName;
        assert (TestInjection.injectPrepRecoveryOpPauseForever());
        SolrParams params = it.req.getParams();
        String cname = params.get("core", "");
        String nodeName = params.get("nodeName");
        String coreNodeName = params.get("coreNodeName");
        Replica.State waitForState = Replica.State.getState((String)params.get("state"));
        Boolean checkLive = params.getBool("checkLive");
        Boolean onlyIfLeader = params.getBool("onlyIfLeader");
        Boolean onlyIfLeaderActive = params.getBool("onlyIfLeaderActive");
        CoreContainer coreContainer = it.handler.coreContainer;
        int conflictWaitMs = coreContainer.getZkController().getLeaderConflictResolveWait();
        log.info("Going to wait for coreNodeName: {}, state: {}, checkLive: {}, onlyIfLeader: {}, onlyIfLeaderActive: {}", new Object[]{coreNodeName, waitForState, checkLive, onlyIfLeader, onlyIfLeaderActive});
        try (SolrCore core = coreContainer.getCore(cname);){
            if (core == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "core not found: " + cname);
            }
            collectionName = core.getCoreDescriptor().getCloudDescriptor().getCollectionName();
            cloudDescriptor = core.getCoreDescriptor().getCloudDescriptor();
        }
        try {
            coreContainer.getZkController().getZkStateReader().waitForState(collectionName, (long)conflictWaitMs, TimeUnit.MILLISECONDS, (n, c) -> {
                Replica replica;
                if (c == null) {
                    return false;
                }
                if (coreContainer.isShutDown()) {
                    log.info("Not going to wait for replica to recover - Solr is shutting down");
                    return false;
                }
                try (SolrCore core = coreContainer.getCore(cname);){
                    if (core == null) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "core not found: " + cname);
                    }
                    if (onlyIfLeader != null && onlyIfLeader.booleanValue() && !core.getCoreDescriptor().getCloudDescriptor().isLeader()) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "We are not the leader");
                    }
                }
                Replica.State state = null;
                boolean live = false;
                Slice slice = c.getSlice(cloudDescriptor.getShardId());
                if (slice != null && (replica = (Replica)slice.getReplicasMap().get(coreNodeName)) != null) {
                    boolean onlyIfActiveCheckResult;
                    boolean leaderDoesNotNeedRecovery;
                    state = replica.getState();
                    live = n.contains(nodeName);
                    Replica.State localState = cloudDescriptor.getLastPublished();
                    boolean bl = leaderDoesNotNeedRecovery = onlyIfLeader != null && onlyIfLeader != false && cname.equals(replica.getStr("core")) && waitForState == Replica.State.RECOVERING && localState == Replica.State.ACTIVE && state == Replica.State.ACTIVE;
                    if (leaderDoesNotNeedRecovery) {
                        log.warn("Leader {} ignoring request to be in the recovering state because it is live and active.", (Object)cname);
                    }
                    ZkShardTerms shardTerms = coreContainer.getZkController().getShardTerms(collectionName, slice.getName());
                    if (waitForState == Replica.State.RECOVERING && shardTerms.registered(coreNodeName) && shardTerms.skipSendingUpdatesTo(coreNodeName)) {
                        shardTerms.refreshTerms();
                    }
                    boolean bl2 = onlyIfActiveCheckResult = onlyIfLeaderActive != null && onlyIfLeaderActive != false && localState != Replica.State.ACTIVE;
                    if (log.isInfoEnabled()) {
                        log.info("In WaitForState(" + String.valueOf(waitForState) + "): collection=" + collectionName + ", shard=" + slice.getName() + ", thisCore=" + cname + ", leaderDoesNotNeedRecovery=" + leaderDoesNotNeedRecovery + ", isLeader=" + cloudDescriptor.isLeader() + ", live=" + live + ", checkLive=" + checkLive + ", currentState=" + String.valueOf(state) + ", localState=" + String.valueOf(localState) + ", nodeName=" + nodeName + ", coreNodeName=" + coreNodeName + ", onlyIfActiveCheckResult=" + onlyIfActiveCheckResult + ", nodeProps: " + String.valueOf(replica));
                    }
                    if (!onlyIfActiveCheckResult && replica != null && (state == waitForState || leaderDoesNotNeedRecovery)) {
                        if (checkLive == null) {
                            return true;
                        }
                        if (checkLive.booleanValue() && live) {
                            return true;
                        }
                        if (!checkLive.booleanValue() && !live) {
                            return true;
                        }
                    }
                }
                return false;
            });
        }
        catch (InterruptedException | TimeoutException e) {
            throw new ZkController.NotInClusterStateException(SolrException.ErrorCode.SERVER_ERROR, "Timeout waiting for collection state.");
        }
    }
}

