from _typeshed import Incomplete
from logging import Logger
from traceback import StackSummary
from typing import Any

log: Logger
ORIGIN_TRACE_HEADER_ATTR_KEY: str

class Entity:
    id: Any
    name: Any
    start_time: Any
    parent_id: Any
    sampled: bool
    in_progress: bool
    http: Any
    annotations: Any
    metadata: Any
    aws: Any
    cause: Any
    subsegments: Any
    end_time: Any
    def __init__(self, name, entity_id: Incomplete | None = None) -> None: ...
    def close(self, end_time: Incomplete | None = None) -> None: ...
    def add_subsegment(self, subsegment) -> None: ...
    def remove_subsegment(self, subsegment) -> None: ...
    def put_http_meta(self, key, value) -> None: ...
    def put_annotation(self, key, value) -> None: ...
    def put_metadata(self, key, value, namespace: str = "default") -> None: ...
    def set_aws(self, aws_meta) -> None: ...
    throttle: bool
    def add_throttle_flag(self) -> None: ...
    fault: bool
    def add_fault_flag(self) -> None: ...
    error: bool
    def add_error_flag(self) -> None: ...
    def apply_status_code(self, status_code) -> None: ...
    def add_exception(self, exception: Exception, stack: StackSummary, remote: bool = False) -> None: ...
    def save_origin_trace_header(self, trace_header) -> None: ...
    def get_origin_trace_header(self): ...
    def serialize(self): ...
    def to_dict(self): ...
