/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.ranking.core.features;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.impl.TextSearchContributor;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.ide.util.scopeChooser.ScopeIdMapper;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.searchEverywhereMl.SearchEverywhereTab;
import com.intellij.usages.impl.ScopeRuleValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\r\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00060\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00060\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u0010\u0018\u001a\u00020\u0010*\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u0010*\u00020\u0019H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereStateFeaturesProvider;", "", "<init>", "()V", "getSearchStateFeatures", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "project", "Lcom/intellij/openapi/project/Project;", "tab", "Lcom/intellij/searchEverywhereMl/SearchEverywhereTab;", "query", "", "searchScope", "Lcom/intellij/ide/util/scopeChooser/ScopeDescriptor;", "isSearchEverywhere", "", "getFileQueryFeatures", "getAllTabQueryFeatures", "getTextContributorFeatures", "hasSuitableContributor", "currentTab", "featuresTab", "isTabWithTextContributor", "isCamelCase", "", "containsAbbreviations", "Companion", "intellij.searchEverywhereMl.ranking.core"})
@SourceDebugExtension(value={"SMAP\nSearchEverywhereStateFeaturesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchEverywhereStateFeaturesProvider.kt\ncom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereStateFeaturesProvider\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,117:1\n1069#2,2:118\n170#2,6:120\n170#2,6:126\n1188#2,3:132\n425#2:135\n507#2,5:136\n1069#2,2:141\n*S KotlinDebug\n*F\n+ 1 SearchEverywhereStateFeaturesProvider.kt\ncom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereStateFeaturesProvider\n*L\n54#1:118,2\n79#1:120,6\n83#1:126,6\n105#1:132,3\n115#1:135\n115#1:136,5\n115#1:141,2\n*E\n"})
public final class SearchEverywhereStateFeaturesProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final IntEventField QUERY_LENGTH_DATA_KEY = EventFields.Int((String)"queryLength");
    @NotNull
    private static final BooleanEventField IS_EMPTY_QUERY_DATA_KEY = EventFields.Boolean((String)"isEmptyQuery");
    @NotNull
    private static final BooleanEventField QUERY_CONTAINS_PATH_DATA_KEY = EventFields.Boolean((String)"queryContainsPath");
    @NotNull
    private static final BooleanEventField QUERY_CONTAINS_COMMAND_CHAR_DATA_KEY = EventFields.Boolean((String)"queryContainsCommandChar");
    @NotNull
    private static final BooleanEventField QUERY_CONTAINS_SPACES_DATA_KEY = EventFields.Boolean((String)"queryContainsSpaces");
    @NotNull
    private static final BooleanEventField QUERY_IS_CAMEL_CASE_DATA_KEY = EventFields.Boolean((String)"queryIsCamelCase");
    @NotNull
    private static final BooleanEventField QUERY_CONTAINS_ABBREVIATIONS_DATA_KEY = EventFields.Boolean((String)"queryContainsAbbreviations");
    @NotNull
    private static final BooleanEventField QUERY_IS_ALL_UPPERCASE_DATA_KEY = EventFields.Boolean((String)"queryIsAllUppercase");
    @NotNull
    private static final BooleanEventField IS_DUMB_MODE = EventFields.Boolean((String)"isDumbMode");
    @NotNull
    private static final StringEventField SEARCH_SCOPE_DATA_KEY = EventFields.StringValidatedByCustomRule((String)"searchScope", ScopeRuleValidator.class);
    @NotNull
    private static final BooleanEventField IS_SEARCH_EVERYWHERE_DATA_KEY = EventFields.Boolean((String)"isSearchEverywhere");
    @NotNull
    private static final BooleanEventField IS_CASE_SENSITIVE = EventFields.Boolean((String)"isCaseSensitive");
    @NotNull
    private static final BooleanEventField IS_WHOLE_WORDS_ONLY = EventFields.Boolean((String)"isWholeWordsOnly");
    @NotNull
    private static final BooleanEventField IS_REGULAR_EXPRESSIONS = EventFields.Boolean((String)"isRegularExpressions");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EventPair<?>> getSearchStateFeatures(@Nullable Project project, @NotNull SearchEverywhereTab tab, @NotNull String query, @Nullable ScopeDescriptor searchScope, boolean isSearchEverywhere) {
        Object object;
        boolean bl;
        BooleanEventField booleanEventField;
        Object[] objectArray;
        block6: {
            void $this$all$iv;
            Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            objectArray = new EventPair[7];
            objectArray[0] = QUERY_LENGTH_DATA_KEY.with((Object)query.length());
            objectArray[1] = IS_EMPTY_QUERY_DATA_KEY.with((Object)(((CharSequence)query).length() == 0 ? 1 : 0));
            objectArray[2] = QUERY_CONTAINS_SPACES_DATA_KEY.with((Object)StringsKt.contains$default((CharSequence)query, (CharSequence)" ", (boolean)false, (int)2, null));
            objectArray[3] = QUERY_IS_CAMEL_CASE_DATA_KEY.with((Object)this.isCamelCase(query));
            objectArray[4] = QUERY_CONTAINS_ABBREVIATIONS_DATA_KEY.with((Object)this.containsAbbreviations(query));
            CharSequence charSequence = query;
            booleanEventField = QUERY_IS_ALL_UPPERCASE_DATA_KEY;
            int n = 5;
            Object[] objectArray2 = objectArray;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (Character.isUpperCase(it)) continue;
                bl = false;
                break block6;
            }
            bl = true;
        }
        boolean bl3 = bl;
        objectArray2[n] = booleanEventField.with((Object)bl3);
        objectArray[6] = IS_SEARCH_EVERYWHERE_DATA_KEY.with((Object)isSearchEverywhere);
        ArrayList features = CollectionsKt.arrayListOf((Object[])objectArray);
        Project project2 = project;
        if (project2 != null) {
            Project it = project2;
            boolean bl4 = false;
            boolean isDumb = DumbService.Companion.isDumb(project);
            features.add(IS_DUMB_MODE.with((Object)isDumb));
        }
        if (this.hasSuitableContributor(tab, (SearchEverywhereTab)SearchEverywhereTab.Files.INSTANCE)) {
            features.addAll((Collection)this.getFileQueryFeatures(query));
        }
        if (this.hasSuitableContributor(tab, (SearchEverywhereTab)SearchEverywhereTab.All.INSTANCE)) {
            features.addAll((Collection)this.getAllTabQueryFeatures(query));
        }
        if ((object = searchScope) != null && (object = object.getDisplayName()) != null) {
            Object searchScopeDisplayName = object;
            boolean bl5 = false;
            String scopeId = ScopeIdMapper.Companion.getInstance().getScopeSerializationId((String)searchScopeDisplayName);
            features.add(SEARCH_SCOPE_DATA_KEY.with((Object)scopeId));
        }
        if (project != null && this.isTabWithTextContributor(tab)) {
            features.addAll((Collection)this.getTextContributorFeatures(project));
        }
        return features;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EventPair<Boolean>> getFileQueryFeatures(String query) {
        int n;
        int n2;
        BooleanEventField booleanEventField;
        int n3;
        block2: {
            void $this$indexOfLast$iv;
            n3 = StringsKt.getLastIndex((CharSequence)query);
            CharSequence charSequence = query;
            booleanEventField = QUERY_CONTAINS_PATH_DATA_KEY;
            boolean $i$f$indexOfLast = false;
            int n4 = $this$indexOfLast$iv.length() + -1;
            if (0 <= n4) {
                do {
                    int index$iv = n4--;
                    char it = $this$indexOfLast$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(it == '/' || it == '\\')) continue;
                    n2 = index$iv;
                    break block2;
                } while (0 <= n4);
            }
            n2 = -1;
        }
        int n5 = n = n2;
        return CollectionsKt.listOf((Object)booleanEventField.with((Object)(1 <= n5 ? n5 < n3 : false)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<EventPair<Boolean>> getAllTabQueryFeatures(String query) {
        int n;
        BooleanEventField booleanEventField;
        block2: {
            void $this$indexOfLast$iv;
            CharSequence charSequence = query;
            booleanEventField = QUERY_CONTAINS_COMMAND_CHAR_DATA_KEY;
            boolean $i$f$indexOfLast = false;
            int n2 = $this$indexOfLast$iv.length() + -1;
            if (0 <= n2) {
                do {
                    int index$iv = n2--;
                    char it = $this$indexOfLast$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(it == '/')) continue;
                    n = index$iv;
                    break block2;
                } while (0 <= n2);
            }
            n = -1;
        }
        int n3 = n;
        return CollectionsKt.listOf((Object)booleanEventField.with((Object)(n3 == 0 ? 1 : 0)));
    }

    private final List<EventPair<Boolean>> getTextContributorFeatures(Project project) {
        FindModel findModel = FindManager.getInstance((Project)project).getFindInProjectModel();
        boolean bl = false;
        Object[] objectArray = new EventPair[]{IS_CASE_SENSITIVE.with((Object)findModel.isCaseSensitive()), IS_WHOLE_WORDS_ONLY.with((Object)findModel.isWholeWordsOnly()), IS_REGULAR_EXPRESSIONS.with((Object)findModel.isRegularExpressions())};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final boolean hasSuitableContributor(SearchEverywhereTab currentTab, SearchEverywhereTab featuresTab) {
        return Intrinsics.areEqual((Object)currentTab, (Object)featuresTab) || Intrinsics.areEqual((Object)currentTab, (Object)SearchEverywhereTab.All.INSTANCE);
    }

    private final boolean isTabWithTextContributor(SearchEverywhereTab tab) {
        String string = tab.getTabId();
        return Intrinsics.areEqual((Object)string, (Object)TextSearchContributor.class.getSimpleName()) ? true : Intrinsics.areEqual((Object)string, (Object)"SearchEverywhereContributor.All");
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCamelCase(CharSequence $this$isCamelCase) {
        CharSequence $this$forEachIndexed$iv = $this$isCamelCase;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            void c;
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int n = index$iv++;
            char c2 = item$iv;
            int index = n;
            boolean bl = false;
            if (index == 0 || Character.isUpperCase((char)c) == Character.isUpperCase($this$isCamelCase.charAt(index - 1))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containsAbbreviations(CharSequence $this$containsAbbreviations) {
        boolean bl;
        block2: {
            void $this$filterTo$iv$iv;
            CharSequence $this$filter$iv = $this$containsAbbreviations;
            boolean $i$f$filter = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl2 = false;
                if (!Character.isLetter(it)) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            CharSequence $this$all$iv = (CharSequence)((Object)destination$iv$iv);
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl3 = false;
                if (Character.isUpperCase(it)) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        return bl;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0!R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0014\u0010\u0012\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0014\u0010\u0014\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u0014\u0010\u0016\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000bR\u0014\u0010\u0018\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000bR\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereStateFeaturesProvider$Companion;", "", "<init>", "()V", "QUERY_LENGTH_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "getQUERY_LENGTH_DATA_KEY$intellij_searchEverywhereMl_ranking_core", "()Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "IS_EMPTY_QUERY_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "getIS_EMPTY_QUERY_DATA_KEY$intellij_searchEverywhereMl_ranking_core", "()Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "QUERY_CONTAINS_PATH_DATA_KEY", "getQUERY_CONTAINS_PATH_DATA_KEY$intellij_searchEverywhereMl_ranking_core", "QUERY_CONTAINS_COMMAND_CHAR_DATA_KEY", "getQUERY_CONTAINS_COMMAND_CHAR_DATA_KEY$intellij_searchEverywhereMl_ranking_core", "QUERY_CONTAINS_SPACES_DATA_KEY", "getQUERY_CONTAINS_SPACES_DATA_KEY$intellij_searchEverywhereMl_ranking_core", "QUERY_IS_CAMEL_CASE_DATA_KEY", "getQUERY_IS_CAMEL_CASE_DATA_KEY$intellij_searchEverywhereMl_ranking_core", "QUERY_CONTAINS_ABBREVIATIONS_DATA_KEY", "getQUERY_CONTAINS_ABBREVIATIONS_DATA_KEY$intellij_searchEverywhereMl_ranking_core", "QUERY_IS_ALL_UPPERCASE_DATA_KEY", "getQUERY_IS_ALL_UPPERCASE_DATA_KEY$intellij_searchEverywhereMl_ranking_core", "IS_DUMB_MODE", "getIS_DUMB_MODE$intellij_searchEverywhereMl_ranking_core", "SEARCH_SCOPE_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "IS_SEARCH_EVERYWHERE_DATA_KEY", "IS_CASE_SENSITIVE", "IS_WHOLE_WORDS_ONLY", "IS_REGULAR_EXPRESSIONS", "getFeaturesDefinition", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "intellij.searchEverywhereMl.ranking.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntEventField getQUERY_LENGTH_DATA_KEY$intellij_searchEverywhereMl_ranking_core() {
            return QUERY_LENGTH_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_EMPTY_QUERY_DATA_KEY$intellij_searchEverywhereMl_ranking_core() {
            return IS_EMPTY_QUERY_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getQUERY_CONTAINS_PATH_DATA_KEY$intellij_searchEverywhereMl_ranking_core() {
            return QUERY_CONTAINS_PATH_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getQUERY_CONTAINS_COMMAND_CHAR_DATA_KEY$intellij_searchEverywhereMl_ranking_core() {
            return QUERY_CONTAINS_COMMAND_CHAR_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getQUERY_CONTAINS_SPACES_DATA_KEY$intellij_searchEverywhereMl_ranking_core() {
            return QUERY_CONTAINS_SPACES_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getQUERY_IS_CAMEL_CASE_DATA_KEY$intellij_searchEverywhereMl_ranking_core() {
            return QUERY_IS_CAMEL_CASE_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getQUERY_CONTAINS_ABBREVIATIONS_DATA_KEY$intellij_searchEverywhereMl_ranking_core() {
            return QUERY_CONTAINS_ABBREVIATIONS_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getQUERY_IS_ALL_UPPERCASE_DATA_KEY$intellij_searchEverywhereMl_ranking_core() {
            return QUERY_IS_ALL_UPPERCASE_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_DUMB_MODE$intellij_searchEverywhereMl_ranking_core() {
            return IS_DUMB_MODE;
        }

        @NotNull
        public final List<EventField<?>> getFeaturesDefinition() {
            Object[] objectArray = new PrimitiveEventField[]{this.getQUERY_LENGTH_DATA_KEY$intellij_searchEverywhereMl_ranking_core(), this.getIS_EMPTY_QUERY_DATA_KEY$intellij_searchEverywhereMl_ranking_core(), this.getQUERY_CONTAINS_PATH_DATA_KEY$intellij_searchEverywhereMl_ranking_core(), this.getQUERY_CONTAINS_COMMAND_CHAR_DATA_KEY$intellij_searchEverywhereMl_ranking_core(), this.getQUERY_CONTAINS_SPACES_DATA_KEY$intellij_searchEverywhereMl_ranking_core(), this.getQUERY_IS_CAMEL_CASE_DATA_KEY$intellij_searchEverywhereMl_ranking_core(), this.getQUERY_CONTAINS_ABBREVIATIONS_DATA_KEY$intellij_searchEverywhereMl_ranking_core(), this.getQUERY_IS_ALL_UPPERCASE_DATA_KEY$intellij_searchEverywhereMl_ranking_core(), this.getIS_DUMB_MODE$intellij_searchEverywhereMl_ranking_core(), SEARCH_SCOPE_DATA_KEY, IS_SEARCH_EVERYWHERE_DATA_KEY, IS_CASE_SENSITIVE, IS_WHOLE_WORDS_ONLY, IS_REGULAR_EXPRESSIONS};
            return CollectionsKt.arrayListOf((Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

