/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.tagging.Tagger;

public class IsEnglishWordFilter
extends RuleFilter {
    private Language english = null;
    private Tagger tagger = null;

    public IsEnglishWordFilter() {
        try {
            this.english = Languages.getLanguageForShortCode("en-US");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.english != null) {
            this.tagger = this.english.createDefaultTagger();
        }
    }

    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> args, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        if (this.tagger == null) {
            return null;
        }
        String[] formPositions = this.getRequired("formPositions", args).split(",");
        ArrayList<String> forms = new ArrayList<String>();
        for (String formPosition : formPositions) {
            forms.add(patternTokens[this.getSkipCorrectedReference(tokenPositions, Integer.parseInt(formPosition))].getToken());
        }
        boolean isEnglish = true;
        String postagsStr = this.getOptional("postags", args);
        if (postagsStr != null) {
            String[] postags = postagsStr.split(",");
            if (postags.length != forms.size()) {
                throw new RuntimeException("The number of forms and postags has to be the same in disambiguation rule with filter IsEnglishWordFilter.");
            }
            for (int i = 0; i < postags.length; ++i) {
                isEnglish = isEnglish && this.wordIsTaggedWith((String)forms.get(i), postags[i]);
            }
        } else {
            for (int i = 0; i < forms.size(); ++i) {
                isEnglish = isEnglish && this.wordIsTagged((String)forms.get(i));
            }
        }
        return isEnglish ? match : null;
    }

    private boolean wordIsTaggedWith(String word, String postag) throws IOException {
        return this.tagger.tag(Collections.singletonList(word)).get(0).matchesPosTagRegex(postag);
    }

    private boolean wordIsTagged(String word) throws IOException {
        return this.tagger.tag(Collections.singletonList(word)).get(0).isTagged();
    }
}

