/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.CommonBundle;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesTree;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesTreeModel;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.SimpleAsyncChangesTreeModel;
import com.intellij.openapi.vcs.changes.ui.TreeActionsToolbarPanel;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class SpecificFilesViewDialog
extends DialogWrapper {
    protected final JPanel myPanel;
    protected final AsyncChangesTree myView;
    protected final Project myProject;

    protected SpecificFilesViewDialog(@NotNull Project project, @NlsContexts.DialogTitle @NotNull String title, @NotNull AsyncChangesTree tree) {
        if (project == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(0);
        }
        if (title == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(1);
        }
        if (tree == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(2);
        }
        super(project, true);
        this.setTitle(title);
        this.myProject = project;
        this.myView = tree;
        this.myView.setTreeStateStrategy(ChangesTree.KEEP_NON_EMPTY);
        Runnable closer = () -> this.close(0);
        EditSourceOnEnterKeyHandler.install((JComponent)((Object)this.myView), (Runnable)closer);
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this.myView), (Runnable)closer);
        this.myView.setMinimumSize((Dimension)new JBDimension(100, 100));
        this.myPanel = this.createPanel();
        this.setOKButtonText(CommonBundle.getCloseButtonText());
        this.init();
        ChangeListAdapter changeListListener = new ChangeListAdapter(){

            public void changeListUpdateDone() {
                SpecificFilesViewDialog.this.myView.rebuildTree();
            }
        };
        ChangeListManager.getInstance((Project)this.myProject).addChangeListListener((ChangeListListener)changeListListener, this.myDisposable);
        this.myView.rebuildTree();
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction()};
        if (actionArray == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(3);
        }
        return actionArray;
    }

    private JPanel createPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        DefaultActionGroup group = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("SPECIFIC_FILES_DIALOG", (ActionGroup)group, true);
        this.addCustomActions(group);
        CommonActionsManager cam = CommonActionsManager.getInstance();
        Expander expander = new Expander();
        group.addSeparator();
        group.add(ActionManager.getInstance().getAction("ChangesView.GroupBy"));
        DefaultActionGroup treeActions = new DefaultActionGroup();
        treeActions.add(cam.createExpandAllHeaderAction((TreeExpander)expander, (JComponent)((Object)this.myView)));
        treeActions.add(cam.createCollapseAllHeaderAction((TreeExpander)expander, (JComponent)((Object)this.myView)));
        TreeActionsToolbarPanel toolbarPanel = new TreeActionsToolbarPanel(actionToolbar, (ActionGroup)treeActions, (JComponent)((Object)this.myView));
        panel.add((Component)toolbarPanel, "North");
        panel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myView)), "Center");
        return panel;
    }

    protected void addCustomActions(@NotNull DefaultActionGroup group) {
        if (group == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(4);
        }
    }

    protected String getDimensionServiceKey() {
        return "com.intellij.openapi.vcs.changes.SpecificFilesViewDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myView;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/SpecificFilesViewDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/SpecificFilesViewDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addCustomActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private class Expander
    implements TreeExpander {
        private Expander() {
        }

        public void expandAll() {
            TreeUtil.expandAll((JTree)((Object)SpecificFilesViewDialog.this.myView));
        }

        public boolean canExpand() {
            return !SpecificFilesViewDialog.this.myView.getGroupingSupport().isNone();
        }

        public void collapseAll() {
            TreeUtil.collapseAll((JTree)((Object)SpecificFilesViewDialog.this.myView), (int)1);
            TreeUtil.expand((JTree)((Object)SpecificFilesViewDialog.this.myView), (int)0);
        }

        public boolean canCollapse() {
            return !SpecificFilesViewDialog.this.myView.getGroupingSupport().isNone();
        }
    }

    private static abstract class MyChangesTree
    extends AsyncChangesTree {
        MyChangesTree(@NotNull Project project) {
            if (project == null) {
                MyChangesTree.$$$reportNull$$$0(0);
            }
            super(project, false, true);
        }

        @Override
        public int getToggleClickCount() {
            return 2;
        }

        @Override
        public void installPopupHandler(@NotNull ActionGroup group) {
            if (group == null) {
                MyChangesTree.$$$reportNull$$$0(1);
            }
            PopupHandler.installPopupMenu((JComponent)((Object)this), (ActionGroup)group, (String)"ChangesViewPopup");
        }

        @Override
        public void resetTreeState() {
            ChangesBrowserNode<?> root = this.getRoot();
            if (root.getChildCount() == 1) {
                TreeNode child = root.getChildAt(0);
                this.expandPath(TreeUtil.getPathFromRoot((TreeNode)child));
            }
        }

        @Override
        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                MyChangesTree.$$$reportNull$$$0(2);
            }
            super.uiDataSnapshot(sink);
            VcsTreeModelData.uiDataSnapshot(sink, this.myProject, (JTree)((Object)this));
            VcsTreeModelData exactSelection = VcsTreeModelData.exactlySelected((JTree)((Object)this));
            sink.lazy(ChangesListView.EXACTLY_SELECTED_FILES_DATA_KEY, () -> VcsTreeModelData.mapToExactVirtualFile(exactSelection));
            sink.set(PlatformDataKeys.DELETE_ELEMENT_PROVIDER, (Object)new VirtualFileDeleteProvider());
            sink.set(PlatformCoreDataKeys.HELP_ID, (Object)"ideaInterface.changes");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/SpecificFilesViewDialog$MyChangesTree";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "installPopupHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "uiDataSnapshot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static abstract class SpecificVirtualFilesViewDialog
    extends SpecificFilesViewDialog {
        protected SpecificVirtualFilesViewDialog(@NotNull Project project, @NlsContexts.DialogTitle @NotNull String title, @NotNull DataKey<Iterable<VirtualFile>> shownDataKey, @NotNull FilesSupplier<VirtualFile> filesSupplier) {
            if (project == null) {
                SpecificVirtualFilesViewDialog.$$$reportNull$$$0(0);
            }
            if (title == null) {
                SpecificVirtualFilesViewDialog.$$$reportNull$$$0(1);
            }
            if (shownDataKey == null) {
                SpecificVirtualFilesViewDialog.$$$reportNull$$$0(2);
            }
            if (filesSupplier == null) {
                SpecificVirtualFilesViewDialog.$$$reportNull$$$0(3);
            }
            super(project, title, new MyFilesTree(project, shownDataKey, filesSupplier));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "shownDataKey";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filesSupplier";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/SpecificFilesViewDialog$SpecificVirtualFilesViewDialog";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static final class MyFilesTree
        extends MyChangesTree {
            @NotNull
            private final DataKey<Iterable<VirtualFile>> myShownDataKey;
            @NotNull
            private final FilesSupplier<VirtualFile> myFilesSupplier;

            MyFilesTree(@NotNull Project project, @NotNull DataKey<Iterable<VirtualFile>> key, @NotNull FilesSupplier<VirtualFile> filesSupplier) {
                if (project == null) {
                    MyFilesTree.$$$reportNull$$$0(0);
                }
                if (key == null) {
                    MyFilesTree.$$$reportNull$$$0(1);
                }
                if (filesSupplier == null) {
                    MyFilesTree.$$$reportNull$$$0(2);
                }
                super(project);
                this.myShownDataKey = key;
                this.myFilesSupplier = filesSupplier;
            }

            @Override
            @NotNull
            protected AsyncChangesTreeModel getChangesTreeModel() {
                AsyncChangesTreeModel asyncChangesTreeModel = SimpleAsyncChangesTreeModel.create(grouping -> {
                    Collection<VirtualFile> files = this.myFilesSupplier.getFiles();
                    return TreeModelBuilder.buildFromVirtualFiles(this.myProject, grouping, files);
                });
                if (asyncChangesTreeModel == null) {
                    MyFilesTree.$$$reportNull$$$0(3);
                }
                return asyncChangesTreeModel;
            }

            @Override
            public void uiDataSnapshot(@NotNull DataSink sink) {
                if (sink == null) {
                    MyFilesTree.$$$reportNull$$$0(4);
                }
                super.uiDataSnapshot(sink);
                VcsTreeModelData treeSelection = VcsTreeModelData.selected((JTree)((Object)this));
                sink.set(this.myShownDataKey, treeSelection.iterateUserObjects(VirtualFile.class));
                sink.set(VcsDataKeys.VIRTUAL_FILES, treeSelection.iterateUserObjects(VirtualFile.class));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "filesSupplier";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/changes/SpecificFilesViewDialog$SpecificVirtualFilesViewDialog$MyFilesTree";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sink";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/changes/SpecificFilesViewDialog$SpecificVirtualFilesViewDialog$MyFilesTree";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChangesTreeModel";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "uiDataSnapshot";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        }
    }

    private static final class MyFilePathsTree
    extends MyChangesTree {
        @NotNull
        private final DataKey<Iterable<FilePath>> myShownDataKey;
        @NotNull
        private final FilesSupplier<FilePath> myFilesSupplier;

        MyFilePathsTree(@NotNull Project project, @NotNull DataKey<Iterable<FilePath>> key, @NotNull FilesSupplier<FilePath> filesSupplier) {
            if (project == null) {
                MyFilePathsTree.$$$reportNull$$$0(0);
            }
            if (key == null) {
                MyFilePathsTree.$$$reportNull$$$0(1);
            }
            if (filesSupplier == null) {
                MyFilePathsTree.$$$reportNull$$$0(2);
            }
            super(project);
            this.myShownDataKey = key;
            this.myFilesSupplier = filesSupplier;
        }

        @Override
        @NotNull
        protected AsyncChangesTreeModel getChangesTreeModel() {
            AsyncChangesTreeModel asyncChangesTreeModel = SimpleAsyncChangesTreeModel.create(grouping -> {
                Collection<FilePath> files = this.myFilesSupplier.getFiles();
                return TreeModelBuilder.buildFromFilePaths(this.myProject, grouping, files);
            });
            if (asyncChangesTreeModel == null) {
                MyFilePathsTree.$$$reportNull$$$0(3);
            }
            return asyncChangesTreeModel;
        }

        @Override
        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                MyFilePathsTree.$$$reportNull$$$0(4);
            }
            super.uiDataSnapshot(sink);
            VcsTreeModelData treeSelection = VcsTreeModelData.selected((JTree)((Object)this));
            sink.set(this.myShownDataKey, treeSelection.iterateUserObjects(FilePath.class));
            sink.set(VcsDataKeys.FILE_PATHS, treeSelection.iterateUserObjects(FilePath.class));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filesSupplier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/SpecificFilesViewDialog$MyFilePathsTree";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/SpecificFilesViewDialog$MyFilePathsTree";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangesTreeModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static abstract class SpecificFilePathsViewDialog
    extends SpecificFilesViewDialog {
        protected SpecificFilePathsViewDialog(@NotNull Project project, @NlsContexts.DialogTitle @NotNull String title, @NotNull DataKey<Iterable<FilePath>> shownDataKey, @NotNull FilesSupplier<FilePath> filesSupplier) {
            if (project == null) {
                SpecificFilePathsViewDialog.$$$reportNull$$$0(0);
            }
            if (title == null) {
                SpecificFilePathsViewDialog.$$$reportNull$$$0(1);
            }
            if (shownDataKey == null) {
                SpecificFilePathsViewDialog.$$$reportNull$$$0(2);
            }
            if (filesSupplier == null) {
                SpecificFilePathsViewDialog.$$$reportNull$$$0(3);
            }
            super(project, title, new MyFilePathsTree(project, shownDataKey, filesSupplier));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "shownDataKey";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filesSupplier";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/SpecificFilesViewDialog$SpecificFilePathsViewDialog";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static interface FilesSupplier<F> {
        @NotNull
        @RequiresBackgroundThread
        public Collection<F> getFiles();
    }
}

