/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.batching.BatchEntry;
import javax.annotation.Nullable;

final class AutoValue_BatchEntry<ElementT, ElementResultT>
extends BatchEntry<ElementT, ElementResultT> {
    @Nullable
    private final ElementT element;
    private final SettableApiFuture<ElementResultT> resultFuture;

    AutoValue_BatchEntry(@Nullable ElementT element, SettableApiFuture<ElementResultT> resultFuture) {
        this.element = element;
        if (resultFuture == null) {
            throw new NullPointerException("Null resultFuture");
        }
        this.resultFuture = resultFuture;
    }

    @Override
    @Nullable
    public ElementT getElement() {
        return this.element;
    }

    @Override
    public SettableApiFuture<ElementResultT> getResultFuture() {
        return this.resultFuture;
    }

    public String toString() {
        return "BatchEntry{element=" + this.element + ", resultFuture=" + this.resultFuture + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BatchEntry) {
            BatchEntry that = (BatchEntry)o;
            return (this.element == null ? that.getElement() == null : this.element.equals(that.getElement())) && this.resultFuture.equals(that.getResultFuture());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.element == null ? 0 : this.element.hashCode();
        h$ *= 1000003;
        return h$ ^= this.resultFuture.hashCode();
    }
}

